/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.http.broker;

import io.sdmx.api.exception.ExceptionCode;
import io.sdmx.api.exception.HttpException;
import io.sdmx.api.exception.SdmxException;
import io.sdmx.api.exception.SdmxServiceUnavailableException;
import io.sdmx.api.exception.SdmxUnauthorisedException;
import io.sdmx.api.io.ReadableDataLocation;
import io.sdmx.utils.core.audit.AuditUtil;
import io.sdmx.utils.core.http.AuthorizationUtil;
import io.sdmx.utils.core.io.OverflowWriteableDataLocation;
import io.sdmx.utils.core.io.StreamUtil;
import io.sdmx.utils.core.object.ObjectUtil;
import io.sdmx.utils.core.process.ReturnProcess;
import io.sdmx.utils.core.thread.ThreadLocalUtil;
import io.sdmx.utils.http.api.model.IHTTPRequest;
import io.sdmx.utils.http.api.model.IHTTPResponse;
import io.sdmx.utils.http.model.HTTPRequestImpl;
import io.sdmx.utils.http.model.Header;
import io.sdmx.utils.http.model.IHttpProxy;
import io.sdmx.utils.http.model.RESTResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Authenticator;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHttpRequest;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestMessageBroker {
    private static final Logger LOG = LoggerFactory.getLogger(RestMessageBroker.class);
    public static final String PROCESS_ID = "SEND_API_REQUEST";
    private static int CONNECT_TIMEOUT = 120000;
    private static int RESPONSE_TIMEOUT = 120000;
    private static String username;
    private static String password;
    private static String userAgent;
    private static Map<String, IHttpProxy> proxyMap;
    private static Map<String, Authenticator> previousAuthentication;

    public static int getConnectTimeout() {
        return CONNECT_TIMEOUT;
    }

    public static int getReadTimeout() {
        return RESPONSE_TIMEOUT;
    }

    private static TrustManager[] getTrustAllCerts() {
        return new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
            }
        }};
    }

    public static void setUserAgent(String value) {
        userAgent = value;
    }

    public static String getUserAgent() {
        return userAgent;
    }

    public static void storeGlobalAuthorization(String username, String password) {
        RestMessageBroker.username = username;
        RestMessageBroker.password = password;
    }

    public static void clearGlobalAuthorization() {
        username = null;
        password = null;
    }

    public static IHTTPResponse sendMessage(Object payload, OutputStream out, String destination) {
        return RestMessageBroker.sendMessage(payload, out, destination, null);
    }

    public static IHTTPResponse sendMessage(Header header) {
        Object payload = header.getPayload();
        OutputStream out = header.getOut();
        String destination = header.getDestination();
        String responseType = header.getAcceptFormat();
        return RestMessageBroker.sendMessage(payload, out, destination, responseType);
    }

    public static IHTTPResponse sendMessageNoResponseFormatSpecified(Header header) {
        Object payload = header.getPayload();
        OutputStream out = header.getOut();
        String destination = header.getDestination();
        return RestMessageBroker.sendMessage(payload, out, destination, null);
    }

    public static ReadableDataLocation toReadableDataLocation(URL url) {
        OverflowWriteableDataLocation wdl = new OverflowWriteableDataLocation();
        RestMessageBroker.sendMessage(wdl.getOutputStream(), url.toString());
        return wdl;
    }

    public static void setProxies(Map<String, IHttpProxy> pMap) {
        proxyMap = pMap;
        previousAuthentication = new HashMap<String, Authenticator>();
    }

    public static IHTTPResponse sendMessage(OutputStream out, String destination) {
        return RestMessageBroker.sendMessage(null, out, destination, null);
    }

    public static IHTTPResponse sendMessage(OutputStream out, String destination, String responseType) {
        return RestMessageBroker.sendMessage(null, out, destination, responseType);
    }

    private static IHTTPResponse sendMessage(final Object payload, final OutputStream out, final String destination, final String responseType) {
        ReturnProcess<IHTTPResponse> process = new ReturnProcess<IHTTPResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runProcess() {
                AuditUtil.addAuditProperty("URL", destination);
                LOG.info("Call URL: " + destination);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Payload of message : " + payload);
                }
                IHTTPRequest req = null;
                if (payload != null && payload instanceof IHTTPRequest) {
                    req = (IHTTPRequest)payload;
                    req.setAccept(responseType);
                } else {
                    req = new HTTPRequestImpl(null);
                }
                if (responseType != null) {
                    req.setAccept(responseType);
                }
                req.setReadTimeout(RESPONSE_TIMEOUT);
                req.setConnectTimeout(CONNECT_TIMEOUT);
                URLConnection urlc = RestMessageBroker.getconnection(destination, req, payload);
                try {
                    IHTTPResponse response = RestMessageBroker.getResponse(urlc, out, payload);
                    if (response != null && response.getResponseHeaders() != null) {
                        JSONObject responseHeadersJson = new JSONObject();
                        for (String header : response.getResponseHeaders().keySet()) {
                            if (header == null) continue;
                            List<String> headerVals = response.getResponseHeaders().get(header);
                            try {
                                if (!ObjectUtil.validCollection(headerVals)) continue;
                                if (headerVals.size() == 1) {
                                    responseHeadersJson.put(header, headerVals.get(0));
                                    continue;
                                }
                                responseHeadersJson.put(header, headerVals);
                            }
                            catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }
                        AuditUtil.addAuditProperty("ResponseHeaders", responseHeadersJson);
                    }
                    this.setReturnObj(response);
                }
                finally {
                    LOG.info("Call URL Complete: " + destination);
                }
            }
        };
        AuditUtil.startAuditEvent(PROCESS_ID, "GET", process);
        return (IHTTPResponse)process.getReturnObj();
    }

    public static HttpResponse sendRawHttpHeader(String serverURL, String method, String service) throws SdmxException {
        HttpResponse response;
        HttpHost host = HttpHost.create(serverURL);
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        BasicHttpRequest purgeRequest = new BasicHttpRequest(method, service);
        try {
            response = httpclient.execute(host, purgeRequest);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    private static URLConnection getconnection(String destination, IHTTPRequest httpRequest, Object payload) {
        Object secureKey;
        HttpURLConnection httpConn;
        URLConnection urlc;
        URL url;
        try {
            url = new URL(destination);
        }
        catch (MalformedURLException e) {
            throw new SdmxServiceUnavailableException((Throwable)e, ExceptionCode.WEB_SERVICE_BAD_CONNECTION, destination);
        }
        IHttpProxy hp = null;
        if (ObjectUtil.validMap(proxyMap)) {
            for (String aDomain : proxyMap.keySet()) {
                if (!url.getHost().matches(aDomain)) continue;
                hp = proxyMap.get(aDomain);
                break;
            }
        }
        if (hp == null) {
            try {
                urlc = url.openConnection();
            }
            catch (IOException e) {
                throw new SdmxServiceUnavailableException((Throwable)e, ExceptionCode.WEB_SERVICE_BAD_CONNECTION, destination);
            }
        }
        String host = hp.getProxyUrl();
        int port = hp.getProxyPort();
        if (ObjectUtil.validString(hp.getProxyUser())) {
            LOG.info("Using Proxy: " + host + ":" + port + " -> " + hp.getProxyUser());
            Authenticator currentAuth = previousAuthentication.get(hp.getDomain());
            if (currentAuth == null) {
                final String proxyUser = hp.getProxyUser();
                final String proxyPassword = hp.getDecryptedPassword();
                currentAuth = new Authenticator(){

                    @Override
                    public PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(proxyUser, proxyPassword.toCharArray());
                    }
                };
                previousAuthentication.put(hp.getDomain(), currentAuth);
            }
            Authenticator.setDefault(currentAuth);
        } else {
            LOG.info("Using Proxy: " + host + ":" + port);
            Authenticator.setDefault(null);
        }
        Proxy webProxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
        try {
            urlc = url.openConnection(webProxy);
        }
        catch (IOException e) {
            throw new SdmxServiceUnavailableException((Throwable)e, ExceptionCode.WEB_SERVICE_BAD_CONNECTION, destination);
        }
        Map<String, String> params = httpRequest.getHeaderParameters();
        params = params == null ? Collections.emptyMap() : new HashMap<String, String>(params);
        if (ThreadLocalUtil.contains("X-Forwarded-For") && !params.containsKey("X-Forwarded-For")) {
            Object ipaddr = ThreadLocalUtil.retrieveFromThread("X-Forwarded-For");
            params.put("X-Forwarded-For", (String)ipaddr);
        }
        if (httpRequest.getAccept() != null) {
            params.put("Accept", httpRequest.getAccept());
        } else {
            params.put("Accept", "*/*;q=1");
        }
        if (payload != null && !params.containsKey("Content-Type")) {
            params.put("Content-Type", "application/text");
        }
        if (ObjectUtil.validString(userAgent)) {
            params.put("User-Agent", userAgent);
        }
        urlc.setDoOutput(true);
        urlc.setAllowUserInteraction(false);
        urlc.addRequestProperty("Accept-Encoding", "gzip");
        if (destination.toLowerCase().startsWith("http")) {
            httpConn = (HttpURLConnection)urlc;
            httpConn.setInstanceFollowRedirects(true);
        }
        if (destination.toLowerCase().startsWith("https")) {
            httpConn = (HttpsURLConnection)urlc;
            httpConn.setInstanceFollowRedirects(true);
        }
        if (ThreadLocalUtil.contains("Authorization") && !params.containsKey("Authorization")) {
            secureKey = ThreadLocalUtil.retrieveFromThread("Authorization");
            if (secureKey != null) {
                params.put("Authorization", (String)secureKey);
            }
        } else if (username != null && password != null) {
            secureKey = AuthorizationUtil.createAuthorizationHeader(username, password);
            params.put("Authorization", (String)secureKey);
        } else if (destination.startsWith("https") && ThreadLocalUtil.contains("P12Certificate")) {
            HttpsURLConnection httpsConn = (HttpsURLConnection)urlc;
            byte[] certificateBytes = (byte[])ThreadLocalUtil.retrieveFromThread("P12Certificate");
            String keyStoreType = (String)ThreadLocalUtil.retrieveFromThread("P12CertificateType");
            if (!ObjectUtil.validString(keyStoreType)) {
                keyStoreType = "PKCS12";
            }
            String keyStorePassword = (String)ThreadLocalUtil.retrieveFromThread("P12CertificatePassword");
            char[] password = keyStorePassword.toCharArray();
            try {
                KeyStore clientStore = KeyStore.getInstance(keyStoreType);
                clientStore.load(new ByteArrayInputStream(certificateBytes), password);
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(clientStore, password);
                KeyManager[] kms = kmf.getKeyManagers();
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(kms, RestMessageBroker.getTrustAllCerts(), new SecureRandom());
                httpsConn.setSSLSocketFactory(sslContext.getSocketFactory());
            }
            catch (Throwable e) {
                throw new SdmxException(e, "Error while trying to attach Certificate to request: " + destination);
            }
        }
        JSONObject requestHeaders = new JSONObject();
        for (String param : params.keySet()) {
            String paramVal = params.get(param);
            try {
                if (param.equalsIgnoreCase("Authorization")) {
                    requestHeaders.put(param, "****");
                } else {
                    requestHeaders.put(param, paramVal);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            urlc.addRequestProperty(param, params.get(param));
        }
        AuditUtil.addAuditProperty("RequestHeaders", requestHeaders);
        AuditUtil.addAuditProperty("ConnectionTimeout", httpRequest.getConnectTimeout());
        AuditUtil.addAuditProperty("ReadTimeout", httpRequest.getReadTimeout());
        urlc.setConnectTimeout(httpRequest.getConnectTimeout());
        urlc.setReadTimeout(httpRequest.getReadTimeout());
        return urlc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IHTTPResponse getResponse(URLConnection urlc, OutputStream out, Object payload) {
        RESTResponse rESTResponse;
        try {
            URLResponse response;
            try {
                if (payload != null) {
                    if (payload instanceof IHTTPRequest) {
                        payload = ((IHTTPRequest)payload).getPayload();
                    }
                    PrintStream ps = new PrintStream(urlc.getOutputStream());
                    if (payload instanceof ByteArrayOutputStream) {
                        ps.write(((ByteArrayOutputStream)payload).toByteArray());
                    } else if (payload instanceof ReadableDataLocation) {
                        ReadableDataLocation rdl = (ReadableDataLocation)payload;
                        StreamUtil.copyStream(rdl.getInputStream(), ps);
                        rdl.close();
                    } else if (payload instanceof InputStream) {
                        StreamUtil.copyStream((InputStream)payload, ps);
                    } else {
                        ps.print(payload);
                    }
                    ps.close();
                }
                response = RestMessageBroker.getInputStream(urlc);
            }
            catch (IOException e) {
                throw new SdmxServiceUnavailableException((Throwable)e, ExceptionCode.WEB_SERVICE_BAD_CONNECTION, e.getMessage());
            }
            if (urlc.getContentEncoding() != null && urlc.getContentEncoding().equals("gzip")) {
                GZIPInputStream gZipInputStream;
                LOG.debug("Response received as GZIP");
                try {
                    gZipInputStream = new GZIPInputStream(response.is);
                }
                catch (IOException e) {
                    throw new SdmxException(e, "I/O Exception while trying to unzip stream retrieved from service:" + urlc.getURL());
                }
                StreamUtil.copyStream(gZipInputStream, out);
            } else {
                LOG.debug("Response received not compressed");
                StreamUtil.copyStream(response.is, out);
            }
            rESTResponse = new RESTResponse(response.status, urlc.getHeaderFields());
        }
        catch (Throwable throwable) {
            StreamUtil.closeStream(out);
            throw throwable;
        }
        StreamUtil.closeStream(out);
        return rESTResponse;
    }

    private static int getResponseStatusCode(URLConnection urlc) {
        if (urlc instanceof HttpURLConnection) {
            try {
                return ((HttpURLConnection)urlc).getResponseCode();
            }
            catch (IOException e) {
                LOG.error(e.getMessage());
                return -1;
            }
        }
        return 0;
    }

    private static URLResponse getInputStream(URLConnection urlc) {
        try {
            InputStream returnStream = urlc.getInputStream();
            AuditUtil.addAuditProperty("HttpStatus", RestMessageBroker.getResponseStatusCode(urlc));
            return new URLResponse(returnStream, 200);
        }
        catch (ConnectException c) {
            throw new SdmxServiceUnavailableException((Throwable)c, ExceptionCode.WEB_SERVICE_BAD_CONNECTION, urlc.getURL());
        }
        catch (SocketException c) {
            throw new SdmxServiceUnavailableException((Throwable)c, ExceptionCode.WEB_SERVICE_BAD_CONNECTION, urlc.getURL());
        }
        catch (SocketTimeoutException c) {
            throw new SdmxServiceUnavailableException((Throwable)c, ExceptionCode.WEB_SERVICE_SOCKET_TIMEOUT, urlc.getReadTimeout() / 1000);
        }
        catch (IOException e) {
            if (urlc instanceof HttpURLConnection) {
                int httpStatusCode = 500;
                try {
                    httpStatusCode = RestMessageBroker.getResponseStatusCode(urlc);
                    String responseMessage = ((HttpURLConnection)urlc).getResponseMessage();
                    if (responseMessage != null) {
                        AuditUtil.addAuditProperty("ErrorResponse", responseMessage);
                    }
                    AuditUtil.addAuditProperty("HttpStatus", httpStatusCode);
                    switch (httpStatusCode) {
                        case 423: {
                            throw new HttpException("User account is locked", 423);
                        }
                        case 403: {
                            throw new HttpException("User is disabled", 403);
                        }
                        case 401: {
                            if (ObjectUtil.validString(responseMessage)) {
                                if (responseMessage.equals("User account is locked")) {
                                    throw new SdmxUnauthorisedException(responseMessage);
                                }
                                if (responseMessage.equals("User is disabled")) {
                                    throw new SdmxUnauthorisedException(responseMessage);
                                }
                            }
                            throw new SdmxUnauthorisedException("Not Authorized - " + e.getMessage());
                        }
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                HttpURLConnection httpConnection = (HttpURLConnection)urlc;
                InputStream is = httpConnection.getErrorStream();
                return new URLResponse(is, httpStatusCode);
            }
            String message = null;
            if (e.getMessage().contains("Server returned HTTP response code:")) {
                String split = e.getMessage().split(":")[1];
                split = split.trim();
                split = split.substring(0, split.indexOf(" "));
                try {
                    int responseCode = Integer.parseInt(split);
                    switch (responseCode) {
                        case 400: {
                            message = "Response Code 400 = The request could not be understood by the server due to malformed syntax";
                            break;
                        }
                        case 401: {
                            message = "Response Code 401 = Authentication failure";
                            break;
                        }
                        case 403: {
                            message = "Response Code 403 = The server understood the request, but is refusing to fulfill it";
                            break;
                        }
                        case 404: {
                            message = "Response Code 404 = Page not found";
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (message != null) {
                throw new SdmxServiceUnavailableException((Throwable)e, ExceptionCode.WEB_SERVICE_BAD_CONNECTION, message);
            }
            throw new SdmxServiceUnavailableException((Throwable)e, ExceptionCode.WEB_SERVICE_BAD_CONNECTION, urlc.getURL());
        }
    }

    public static void setResponseTimeout(int responseTimeout) {
        RESPONSE_TIMEOUT = responseTimeout * 1000;
    }

    public static void setConnectTimeout(int responseTimeout) {
        CONNECT_TIMEOUT = responseTimeout * 1000;
    }

    static {
        previousAuthentication = new HashMap<String, Authenticator>();
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, RestMessageBroker.getTrustAllCerts(), new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession ssls) {
                    return true;
                }
            });
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private static class URLResponse {
        private InputStream is;
        private int status;

        public URLResponse(InputStream is, int status) {
            this.is = is;
            this.status = status;
        }
    }
}

