/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.http.broker;

import io.sdmx.api.exception.ExceptionCode;
import io.sdmx.api.exception.SdmxException;
import io.sdmx.api.exception.SdmxServiceUnavailableException;
import io.sdmx.api.io.ReadableDataLocation;
import io.sdmx.utils.core.http.AuthorizationUtil;
import io.sdmx.utils.core.io.StreamUtil;
import io.sdmx.utils.core.object.ObjectUtil;
import io.sdmx.utils.core.thread.ThreadLocalUtil;
import io.sdmx.utils.http.api.engine.IHTTPQueryEngine;
import io.sdmx.utils.http.api.model.IHTTPRequest;
import io.sdmx.utils.http.api.model.IRESTRequest;
import io.sdmx.utils.http.model.JSONObjectResponse;
import io.sdmx.utils.http.model.RESTResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPQueryEngine
implements IHTTPQueryEngine {
    private final Logger LOG = LoggerFactory.getLogger(HTTPQueryEngine.class);
    private int defaultConnectTimeout = 120000;
    private int defaultResponseTimeout = 120000;
    private String username;
    private String password;
    private String userAgent;

    public HTTPQueryEngine() {
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, this.getTrustAllCerts(), new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession ssls) {
                    return true;
                }
            });
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public int getConnectTimeout() {
        return this.defaultConnectTimeout;
    }

    public int getReadTimeout() {
        return this.defaultResponseTimeout;
    }

    private TrustManager[] getTrustAllCerts() {
        return new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
            }
        }};
    }

    @Override
    public RESTResponse sendMessage(IRESTRequest request, OutputStream out) {
        if (this.LOG.isTraceEnabled()) {
            this.LOG.trace("Send message to destination : " + request.getUrl());
            this.LOG.trace("Payload of message : " + request.getPayload());
        }
        URLConnection urlc = this.getconnection(request);
        return this.getResponse(urlc, out, request.getPayload());
    }

    @Override
    public JSONObjectResponse getJson(IRESTRequest request) {
        if (this.LOG.isTraceEnabled()) {
            this.LOG.trace("Send message to destination : " + request.getUrl());
            this.LOG.trace("Payload of message : " + request.getPayload());
        }
        URLConnection urlc = this.getconnection(request);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        RESTResponse response = this.getResponse(urlc, bos, request.getPayload());
        try {
            return new JSONObjectResponse(response, new JSONObject(new String(bos.toByteArray())));
        }
        catch (JSONException e) {
            return new JSONObjectResponse(response, bos.toByteArray());
        }
    }

    private URLConnection getconnection(IRESTRequest request) {
        Object secureKey;
        HttpURLConnection httpConn;
        URLConnection urlc;
        URL url;
        String destination = request.getUrl();
        try {
            url = new URL(request.getUrl());
        }
        catch (MalformedURLException e) {
            throw new SdmxServiceUnavailableException((Throwable)e, ExceptionCode.WEB_SERVICE_BAD_CONNECTION, request.getUrl());
        }
        try {
            urlc = url.openConnection();
        }
        catch (IOException e) {
            throw new SdmxServiceUnavailableException((Throwable)e, ExceptionCode.WEB_SERVICE_BAD_CONNECTION, request.getUrl());
        }
        Map<String, String> params = request.getHeaderParameters();
        urlc.setDoOutput(true);
        urlc.setAllowUserInteraction(false);
        for (String param : params.keySet()) {
            urlc.addRequestProperty(param, params.get(param));
        }
        if (!params.containsKey("Content-Type")) {
            urlc.addRequestProperty("Content-Type", "application/text");
        }
        urlc.addRequestProperty("Accept-Encoding", "gzip");
        if (ObjectUtil.validString(this.userAgent)) {
            urlc.setRequestProperty("User-Agent", this.userAgent);
        }
        if (destination.toLowerCase().startsWith("http")) {
            httpConn = (HttpURLConnection)urlc;
            httpConn.setInstanceFollowRedirects(true);
        }
        if (destination.toLowerCase().startsWith("https")) {
            httpConn = (HttpsURLConnection)urlc;
            httpConn.setInstanceFollowRedirects(true);
        }
        if (request.getBasicAuthentication() != null) {
            urlc.addRequestProperty("Authorization", request.getBasicAuthentication().getBasicAuthenitcation());
        } else if (ThreadLocalUtil.contains("Authorization") && !params.containsKey("Authorization")) {
            secureKey = ThreadLocalUtil.retrieveFromThread("Authorization");
            if (secureKey != null) {
                urlc.addRequestProperty("Authorization", (String)secureKey);
            }
        } else if (this.username != null && this.password != null) {
            secureKey = AuthorizationUtil.createAuthorizationHeader(this.username, this.password);
            urlc.addRequestProperty("Authorization", (String)secureKey);
        } else if (destination.startsWith("https") && ThreadLocalUtil.contains("P12Certificate")) {
            HttpsURLConnection httpsConn = (HttpsURLConnection)urlc;
            byte[] certificateBytes = (byte[])ThreadLocalUtil.retrieveFromThread("P12Certificate");
            String keyStoreType = (String)ThreadLocalUtil.retrieveFromThread("P12CertificateType");
            if (!ObjectUtil.validString(keyStoreType)) {
                keyStoreType = "PKCS12";
            }
            String keyStorePassword = (String)ThreadLocalUtil.retrieveFromThread("P12CertificatePassword");
            char[] password = keyStorePassword.toCharArray();
            try {
                KeyStore clientStore = KeyStore.getInstance(keyStoreType);
                clientStore.load(new ByteArrayInputStream(certificateBytes), password);
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(clientStore, password);
                KeyManager[] kms = kmf.getKeyManagers();
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(kms, this.getTrustAllCerts(), new SecureRandom());
                httpsConn.setSSLSocketFactory(sslContext.getSocketFactory());
            }
            catch (Throwable e) {
                throw new SdmxException(e, "Error while trying to attach Certificate to request: " + destination);
            }
        }
        if (ThreadLocalUtil.contains("X-Forwarded-For") && !params.containsKey("X-Forwarded-For")) {
            Object ipaddr = ThreadLocalUtil.retrieveFromThread("X-Forwarded-For");
            urlc.addRequestProperty("X-Forwarded-For", (String)ipaddr);
        }
        if (request.getAccept() != null) {
            urlc.addRequestProperty("Accept", request.getAccept());
        } else {
            urlc.addRequestProperty("Accept", "*/*;q=1");
        }
        urlc.setConnectTimeout(request.getConnectTimeout());
        urlc.setReadTimeout(request.getReadTimeout());
        return urlc;
    }

    private RESTResponse getResponse(URLConnection urlc, OutputStream out, Object payload) {
        Object ps;
        try {
            if (payload != null) {
                if (payload instanceof IHTTPRequest) {
                    payload = ((IHTTPRequest)payload).getPayload();
                }
                ps = new PrintStream(urlc.getOutputStream());
                if (payload instanceof ByteArrayOutputStream) {
                    ((PrintStream)ps).write(((ByteArrayOutputStream)payload).toByteArray());
                } else if (payload instanceof ReadableDataLocation) {
                    ReadableDataLocation rdl = (ReadableDataLocation)payload;
                    StreamUtil.copyStream(rdl.getInputStream(), (OutputStream)ps);
                    rdl.close();
                } else if (payload instanceof InputStream) {
                    StreamUtil.copyStream((InputStream)payload, (OutputStream)ps);
                } else {
                    ((PrintStream)ps).print(payload);
                }
                ((PrintStream)ps).close();
            }
            ps = this.getRestResponse(urlc, out);
        }
        catch (IOException e) {
            try {
                throw new SdmxServiceUnavailableException((Throwable)e, ExceptionCode.WEB_SERVICE_BAD_CONNECTION, e.getMessage());
            }
            catch (Throwable throwable) {
                StreamUtil.closeStream(out);
                throw throwable;
            }
        }
        StreamUtil.closeStream(out);
        return ps;
    }

    private RESTResponse getRestResponse(URLConnection urlc, OutputStream out) {
        int responseStatus;
        InputStream stream;
        block12: {
            stream = null;
            responseStatus = 200;
            try {
                stream = urlc.getInputStream();
            }
            catch (ConnectException c) {
                throw new SdmxServiceUnavailableException((Throwable)c, ExceptionCode.WEB_SERVICE_BAD_CONNECTION, urlc.getURL());
            }
            catch (SocketException c) {
                throw new SdmxServiceUnavailableException((Throwable)c, ExceptionCode.WEB_SERVICE_BAD_CONNECTION, urlc.getURL());
            }
            catch (SocketTimeoutException c) {
                throw new SdmxServiceUnavailableException((Throwable)c, ExceptionCode.WEB_SERVICE_SOCKET_TIMEOUT, urlc.getReadTimeout() / 1000);
            }
            catch (IOException e) {
                if (!(urlc instanceof HttpURLConnection)) break block12;
                try {
                    responseStatus = ((HttpURLConnection)urlc).getResponseCode();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                HttpURLConnection httpConnection = (HttpURLConnection)urlc;
                stream = httpConnection.getErrorStream();
            }
        }
        if (stream != null) {
            if (urlc.getContentEncoding() != null && urlc.getContentEncoding().equals("gzip")) {
                GZIPInputStream gZipInputStream;
                this.LOG.debug("Response received as GZIP");
                try {
                    gZipInputStream = new GZIPInputStream(stream);
                }
                catch (IOException e) {
                    throw new SdmxException(e, "I/O Exception while trying to unzip stream retrieved from service:" + urlc.getURL());
                }
                StreamUtil.copyStream(gZipInputStream, out);
            } else {
                this.LOG.debug("Response received not compressed");
                StreamUtil.copyStream(stream, out);
            }
        }
        return new RESTResponse(responseStatus, urlc.getHeaderFields());
    }

    public void setResponseTimeout(int responseTimeout) {
        this.defaultResponseTimeout = responseTimeout * 1000;
    }

    public void setConnectTimeout(int responseTimeout) {
        this.defaultConnectTimeout = responseTimeout * 1000;
    }

    public void setUserAgent(String value) {
        this.userAgent = value;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void storeGlobalAuthorization(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public void clearGlobalAuthorization() {
        this.username = null;
        this.password = null;
    }
}

