/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.xml;

import io.sdmx.api.exception.SdmxException;
import io.sdmx.api.exception.SdmxSemmanticException;
import io.sdmx.api.io.ReadableDataLocation;
import io.sdmx.utils.core.xml.StaxReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtils {
    public static Document document(InputStream is) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) {
                    return new InputSource(new StringReader(""));
                }
            });
            return db.parse(is);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new SdmxSemmanticException(e, "Could not read xml document");
        }
    }

    public static NodeList searchForNodeList(Document document, String xpath) {
        try {
            return (NodeList)XPathFactory.newInstance().newXPath().compile(xpath).evaluate(document, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new SdmxSemmanticException(e, "Could not read xml document");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isXML(ReadableDataLocation rdl) {
        SdmxException.disableExceptionTrace(true);
        StaxReader reader = null;
        try {
            reader = new StaxReader(rdl);
            reader.moveNextNode();
            boolean bl = true;
            return bl;
        }
        catch (Throwable th) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            SdmxException.disableExceptionTrace(false);
        }
    }

    public static String formatXml(String unformattedXml) {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(new StringWriter());
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) {
                    return new InputSource(new StringReader(""));
                }
            });
            InputSource is = new InputSource(new StringReader(unformattedXml));
            Document doc = db.parse(is);
            DOMSource source = new DOMSource(doc);
            transformer.transform(source, result);
            return result.getWriter().toString();
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
    }
}

