/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.xml;

import io.sdmx.api.exception.SdmxException;
import io.sdmx.utils.core.object.ObjectUtil;
import io.sdmx.utils.core.xml.IndentingXMLStreamWriter;
import io.sdmx.utils.core.xml.Namespace;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class StaxWriter {
    public static final String XML_NS = "http://www.w3.org/XML/1998/namespace";
    public static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";
    private XMLStreamWriter writer;
    private Namespace[] namespaces;
    private String schemaLocation;

    public StaxWriter(OutputStream out, String schemaLocation, boolean prettyPrint, Namespace ... ns) {
        this.namespaces = ns;
        XMLOutputFactory xmlOutputfactory = XMLOutputFactory.newInstance();
        try {
            this.writer = xmlOutputfactory.createXMLStreamWriter(out, StandardCharsets.UTF_8.toString());
            if (prettyPrint) {
                this.writer = new IndentingXMLStreamWriter(this.writer);
            }
            this.schemaLocation = schemaLocation;
        }
        catch (XMLStreamException e) {
            throw new SdmxException(e, "Could not create XML Writer");
        }
    }

    public void startDocument(Namespace ns, String element) {
        try {
            this.writer.writeStartDocument();
            if (ns != null) {
                this.writer.writeStartElement(ns.getNamespacePrefix(), element, ns.getNamespaceURL());
            } else {
                this.writer.writeStartElement(element);
            }
            this.writer.writeNamespace("xsi", XSI_NS);
            this.writer.writeNamespace("xml", XML_NS);
            if (this.namespaces != null) {
                for (Namespace currnetNs : this.namespaces) {
                    this.writer.writeNamespace(currnetNs.getNamespacePrefix(), currnetNs.getNamespaceURL());
                }
            }
            if (ObjectUtil.validString(this.schemaLocation)) {
                this.writer.writeAttribute(XSI_NS, "schemaLocation", this.schemaLocation);
            }
        }
        catch (XMLStreamException e) {
            throw new SdmxException(e, "Could not create XML Writer");
        }
    }

    public void writeNameSpace(Namespace ns) {
        if (ns != null) {
            try {
                this.writer.writeNamespace(ns.getNamespacePrefix(), ns.getNamespaceURL());
            }
            catch (XMLStreamException e) {
                throw new SdmxException(e, "Could not create XML Writer");
            }
        }
    }

    public void writeAttribute(String id, Boolean value) {
        if (value != null) {
            this.writeAttribute(id, value.toString());
        }
    }

    public void writeAttribute(String id, Integer value) {
        if (value != null) {
            this.writeAttribute(id, value.toString());
        }
    }

    public void writeAttribute(String id, String value) {
        if (ObjectUtil.validString(value)) {
            try {
                this.writer.writeAttribute(id, value);
            }
            catch (XMLStreamException e) {
                throw new SdmxException(e, "Could not write attribute '" + id + "' with value '" + value + "'");
            }
        }
    }

    public void writeXMLLang(String value) {
        if (ObjectUtil.validString(value)) {
            try {
                this.writer.writeAttribute("xml", XML_NS, "lang", value);
            }
            catch (XMLStreamException e) {
                throw new SdmxException(e, "Could not write xml:lang with value '" + value + "'");
            }
        }
    }

    public void writeAttributes(Map<String, String> attributes) {
        if (attributes != null) {
            for (String key : attributes.keySet()) {
                this.writeAttribute(key, attributes.get(key));
            }
        }
    }

    public void writeElement(Namespace ns, String elementName, String elementText) {
        if (ObjectUtil.validString(elementText)) {
            this.writeElement(ns, elementName, elementText, null);
        }
    }

    public void writeElement(Namespace ns, String elementName, Map<String, String> attributes) {
        this.writeElement(ns, elementName, null, attributes, false);
    }

    public void writeElement(Namespace ns, String elementName, String elementText, Map<String, String> attributes) {
        this.writeElement(ns, elementName, elementText, attributes, true);
    }

    private void writeElement(Namespace ns, String elementName, String elementText, Map<String, String> attributes, boolean endElement) {
        if (elementName != null) {
            this.writeStartElement(ns, elementName);
        }
        this.writeAttributes(attributes);
        if (elementText != null) {
            this.writeElementText(elementText);
        }
        if (endElement) {
            this.writeEndElement();
        }
    }

    public void writeElementText(String elementText) {
        if (elementText != null) {
            try {
                this.writer.writeCharacters(elementText);
            }
            catch (XMLStreamException e) {
                throw new SdmxException(e, "Could not create XML Writer");
            }
        }
    }

    public void writeStartElement(Namespace ns, String elementName) {
        try {
            if (ns != null) {
                this.writer.writeStartElement(ns.getNamespacePrefix(), elementName, ns.getNamespaceURL());
            } else {
                this.writer.writeStartElement(elementName);
            }
        }
        catch (XMLStreamException e) {
            throw new SdmxException(e, "Could not create XML Writer");
        }
    }

    public void writeEndElement() {
        try {
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new SdmxException(e, "Could not create XML Writer");
        }
    }

    public void close() {
        try {
            this.writer.writeEndDocument();
            this.writer.close();
        }
        catch (XMLStreamException e) {
            throw new SdmxException(e, "Could not close XML Writer");
        }
    }
}

