/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.xml;

import io.sdmx.utils.core.object.ObjectUtil;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class StaxUtil {
    private static final String XML_NS = "http://www.w3.org/XML/1998/namespace";

    /*
     * WARNING - void declaration
     */
    public static void copyNode(XMLStreamReader parser, boolean deepCopy, boolean includeCurrentNode, boolean includeNamespaces, XMLStreamWriter ... writers) throws XMLStreamException {
        if (writers == null || writers.length == 0) {
            throw new IllegalArgumentException("StxUtil.copyNode expects at least one XMLStreamWriter to copy to");
        }
        if (includeCurrentNode) {
            if (ObjectUtil.validString(parser.getNamespaceURI())) {
                for (XMLStreamWriter xMLStreamWriter : writers) {
                    xMLStreamWriter.writeStartElement(parser.getNamespaceURI(), parser.getLocalName());
                }
            } else {
                for (XMLStreamWriter xMLStreamWriter : writers) {
                    xMLStreamWriter.writeStartElement(parser.getLocalName());
                }
            }
            if (includeNamespaces) {
                for (int i = 0; i < parser.getNamespaceCount(); ++i) {
                    String nsPrefix = parser.getNamespacePrefix(i);
                    String nsUri = parser.getNamespaceURI(i);
                    for (XMLStreamWriter writer : writers) {
                        writer.writeNamespace(nsPrefix, nsUri);
                    }
                }
            }
            for (int i = 0; i < parser.getAttributeCount(); ++i) {
                String attNs = parser.getAttributeNamespace(i);
                String attName = parser.getAttributeLocalName(i);
                String string = parser.getAttributeValue(i);
                if (ObjectUtil.validString(attNs)) {
                    if (attNs.equals(XML_NS)) {
                        for (XMLStreamWriter writer : writers) {
                            writer.writeAttribute("xml", attNs, attName, string);
                        }
                        continue;
                    }
                    for (XMLStreamWriter writer : writers) {
                        writer.writeAttribute(attNs, attName, string);
                    }
                    continue;
                }
                for (XMLStreamWriter writer : writers) {
                    writer.writeAttribute(attName, string);
                }
            }
        }
        if (deepCopy) {
            while (parser.hasNext()) {
                void var8_26;
                int n;
                int event = parser.next();
                if (event == 4) {
                    void var8_24;
                    XMLStreamWriter[] xMLStreamWriterArray = writers;
                    n = xMLStreamWriterArray.length;
                    boolean bl = false;
                    while (var8_24 < n) {
                        XMLStreamWriter writer = xMLStreamWriterArray[var8_24];
                        writer.writeCharacters(parser.getText());
                        ++var8_24;
                    }
                    continue;
                }
                if (event == 1) {
                    StaxUtil.copyNode(parser, true, true, includeNamespaces, writers);
                    continue;
                }
                if (event != 2) continue;
                XMLStreamWriter[] xMLStreamWriterArray = writers;
                n = xMLStreamWriterArray.length;
                boolean bl = false;
                while (var8_26 < n) {
                    XMLStreamWriter writer = xMLStreamWriterArray[var8_26];
                    writer.writeEndElement();
                    ++var8_26;
                }
                return;
            }
        }
    }

    @Deprecated
    public static void skipNode(XMLStreamReader parser) throws XMLStreamException {
        while (parser.hasNext()) {
            int event = parser.next();
            if (event == 1) {
                StaxUtil.skipNode(parser);
                continue;
            }
            if (event != 2) continue;
            return;
        }
    }

    @Deprecated
    public static boolean skipToNode(XMLStreamReader parser, String nodeName) throws XMLStreamException {
        while (parser.hasNext()) {
            int event = parser.next();
            if (event != 1 || !parser.getLocalName().equals(nodeName)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean jumpToNode(XMLStreamReader parser, String findNodeName, String doNotProcessPastNodeName) throws XMLStreamException {
        while (parser.hasNext()) {
            String nodeName;
            int event = parser.next();
            if (event == 1 && (nodeName = parser.getLocalName()).equals(findNodeName)) {
                return true;
            }
            if (event != 2) continue;
            nodeName = parser.getLocalName();
            if (doNotProcessPastNodeName == null || !nodeName.equals(doNotProcessPastNodeName)) continue;
            return false;
        }
        return false;
    }

    @Deprecated
    public static boolean skipToEndNode(XMLStreamReader parser, String nodeName) throws XMLStreamException {
        while (parser.hasNext()) {
            int event = parser.next();
            if (event != 2 || !parser.getLocalName().equals(nodeName)) continue;
            return true;
        }
        return false;
    }

    public static String parseString(XMLStreamReader parser) throws XMLStreamException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XMLOutputFactory xmlOutputfactory = XMLOutputFactory.newInstance();
        XMLStreamWriter writer = xmlOutputfactory.createXMLStreamWriter(out);
        writer.writeStartDocument();
        boolean started = false;
        int event = 1;
        String endElement = parser.getLocalName();
        int level = 0;
        while (true) {
            switch (event) {
                case 1: {
                    if (parser.getLocalName().equals(endElement)) {
                        ++level;
                    }
                    writer.writeStartElement(parser.getNamespaceURI(), parser.getLocalName());
                    if (!started) {
                        writer.writeNamespace("xml", XML_NS);
                        started = true;
                    }
                    for (int i = 0; i < parser.getAttributeCount(); ++i) {
                        if (parser.getAttributeNamespace(i) == null) {
                            writer.writeAttribute(parser.getAttributeLocalName(i), parser.getAttributeValue(i));
                            continue;
                        }
                        writer.writeAttribute(parser.getAttributeNamespace(i), parser.getAttributeLocalName(i), parser.getAttributeValue(i));
                    }
                    break;
                }
                case 4: {
                    writer.writeCharacters(parser.getText());
                    break;
                }
                case 2: {
                    writer.writeEndElement();
                    if (!parser.getLocalName().equals(endElement)) break;
                    if (level == 1) {
                        writer.flush();
                        writer.close();
                        return out.toString();
                    }
                    --level;
                }
            }
            event = parser.next();
        }
    }

    public static void isSameXML(InputStream xmlOne, InputStream xmlTwo, String ignoreAttrValue, String ... ignoreNodes) throws Exception {
        HashSet<String> ignoreAttrValues = new HashSet<String>();
        ignoreAttrValues.add(ignoreAttrValue);
        StaxUtil.isSameXML(xmlOne, xmlTwo, null, ignoreAttrValues, ignoreNodes);
    }

    public static void isSameXML(InputStream xmlOne, InputStream xmlTwo, Set<String> ignoreAttrIds, Set<String> ignoreAttrValues, String ... ignoreNodes) throws Exception {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        factory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        XMLStreamReader parser1 = factory.createXMLStreamReader(xmlOne, "UTF-8");
        XMLStreamReader parser2 = factory.createXMLStreamReader(xmlTwo, "UTF-8");
        String nodeA = null;
        String nodeB = null;
        int element = 0;
        int a = -1;
        int b = -1;
        block0: while (parser1.hasNext()) {
            int i;
            a = parser1.next();
            b = parser2.next();
            while (a == 6) {
                a = parser1.next();
            }
            while (b == 6) {
                b = parser2.next();
            }
            if (parser1.isCharacters()) {
                if (ObjectUtil.validString(parser1.getText())) {
                    if (!parser2.isCharacters()) {
                        throw new IllegalArgumentException("Text Differs on Node:" + nodeA);
                    }
                    if (!(parser1.getText().equals(parser2.getText()) || parser1.getText().equals("$IGNORE") || parser2.getText().equals("$IGNORE"))) {
                        throw new IllegalArgumentException("Text Differs on Node:" + nodeA + "\nExpected:" + parser1.getText() + "\nActual:" + parser2.getText());
                    }
                } else {
                    a = parser1.next();
                    if (parser2.isCharacters() && !ObjectUtil.validString(parser2.getText())) {
                        b = parser2.next();
                    }
                }
            } else if (parser2.isCharacters()) {
                if (ObjectUtil.validString(parser2.getText())) {
                    throw new IllegalArgumentException("Text Differs on Node:" + nodeA + " : " + parser2.getText());
                }
                b = parser2.next();
            }
            if (a == 2) {
                if (b == a) continue;
                nodeA = parser1.getLocalName();
                throw new IllegalArgumentException("Input A is ending XML element: " + nodeA + " whilst input B is not");
            }
            if (a != 1) continue;
            ++element;
            nodeA = parser1.getLocalName();
            if (b != 1) {
                while (parser2.hasNext()) {
                    b = parser2.next();
                    if (b != 1) continue;
                    nodeB = parser2.getLocalName();
                    break;
                }
            }
            if (b != 1) {
                throw new IllegalArgumentException("Parser B end of document, Parser A on node: " + nodeA);
            }
            nodeB = parser2.getLocalName();
            if (!nodeA.equals(nodeB)) {
                throw new IllegalArgumentException("XML NODES DIFFER: " + nodeA + "," + nodeB);
            }
            for (String ignoreNode : ignoreNodes) {
                if (!nodeA.equals(ignoreNode)) continue;
                StaxUtil.skipNode(parser1);
                StaxUtil.skipNode(parser2);
                continue block0;
            }
            if (parser1.getNamespaceCount() != parser2.getNamespaceCount()) {
                int i2;
                StringBuilder sb = new StringBuilder();
                sb.append("Namespace count for parser 1 : " + parser1.getNamespaceCount() + "\n");
                for (i2 = 0; i2 < parser1.getNamespaceCount(); ++i2) {
                    sb.append("Parser 1 Namespace #" + (i2 + 1) + ":  " + parser1.getNamespaceURI(i2) + "\n");
                }
                sb.append("Namespace count for parser 2 : " + parser2.getNamespaceCount() + "\n");
                for (i2 = 0; i2 < parser2.getNamespaceCount(); ++i2) {
                    sb.append("Parser 2 Namespace #" + (i2 + 1) + ":  " + parser2.getNamespaceURI(i2) + "\n");
                }
                throw new IllegalArgumentException("Namespace count differs on node:" + nodeA + "\n" + sb.toString());
            }
            for (int i3 = 0; i3 < parser1.getNamespaceCount(); ++i3) {
                boolean found = false;
                String nameSpaceURI = parser1.getNamespaceURI(i3);
                for (int j = 0; j < parser2.getNamespaceCount(); ++j) {
                    if (!parser2.getNamespaceURI(j).equals(nameSpaceURI)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                throw new IllegalArgumentException("Namespace not found " + nameSpaceURI);
            }
            int ac1 = 0;
            int ac2 = 0;
            for (i = 0; i < parser1.getAttributeCount(); ++i) {
                String attributeLocalName = parser1.getAttributeLocalName(i);
                if (ignoreAttrIds != null && ignoreAttrIds.contains(attributeLocalName)) continue;
                ++ac1;
            }
            for (i = 0; i < parser2.getAttributeCount(); ++i) {
                String attributeLocalName = parser2.getAttributeLocalName(i);
                if (ignoreAttrIds != null && ignoreAttrIds.contains(attributeLocalName)) continue;
                ++ac2;
            }
            if (ac1 != ac2) {
                throw new IllegalArgumentException("Attribute count differs on node:" + nodeA);
            }
            for (i = 0; i < parser1.getAttributeCount(); ++i) {
                int j;
                boolean found = false;
                String attributeLocalName = parser1.getAttributeLocalName(i);
                String attributeNameSpace = parser1.getAttributeNamespace(i);
                String attributeValue = parser1.getAttributeValue(i);
                if (attributeValue.equals("$IGNORE")) continue;
                for (j = 0; j < parser2.getAttributeCount(); ++j) {
                    if (!parser2.getAttributeLocalName(j).equals(attributeLocalName)) continue;
                    if (attributeNameSpace != null || parser2.getAttributeNamespace(j) != null) {
                        if (attributeNameSpace == null && parser2.getAttributeNamespace(j) != null) {
                            throw new IllegalArgumentException("ATTRIBUTE NAMESPACE DIFFERS " + parser2.getAttributeNamespace(i) + "," + attributeNameSpace);
                        }
                        if (attributeNameSpace != null && parser2.getAttributeNamespace(j) == null) {
                            throw new IllegalArgumentException("ATTRIBUTE NAMESPACE DIFFERS " + parser2.getAttributeNamespace(i) + "," + attributeNameSpace);
                        }
                        if (!parser2.getAttributeNamespace(j).equals(attributeNameSpace)) {
                            throw new IllegalArgumentException("ATTRIBUTE NAMESPACE DIFFERS " + parser2.getAttributeNamespace(i) + "," + attributeNameSpace);
                        }
                    }
                    found = true;
                    break;
                }
                if (!found) {
                    throw new IllegalArgumentException("ATTRIBUTE NOT FOUND ON NODE '" + nodeA + "' : " + attributeLocalName);
                }
                if (ignoreAttrIds != null && ignoreAttrIds.contains(attributeLocalName) || ignoreAttrValues == null || ignoreAttrValues.contains(attributeValue) || parser2.getAttributeValue(j).equals(attributeValue) || parser2.getAttributeValue(j).equals("$IGNORE")) continue;
                String line_separator = System.getProperty("line.separator");
                throw new IllegalArgumentException("ATTRIBUTE VALUE DIFFERS on: " + attributeLocalName + " - Node: " + element + line_separator + attributeValue + line_separator + parser2.getAttributeValue(j));
            }
        }
    }
}

