/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.xml;

import io.sdmx.api.io.ReadableDataLocation;
import io.sdmx.api.xml.IStaxReader;
import io.sdmx.utils.core.io.StreamUtil;
import io.sdmx.utils.core.xml.StaxException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class StaxReader
implements IStaxReader {
    private Stack<String> stack = new Stack();
    private ReadableDataLocation rdl;
    private InputStream stream;
    private XMLStreamReader streamReader;
    private Map<String, String> attributes;
    private String elementName;
    private boolean isStartElement;
    private boolean pop;
    private boolean hasDocType = false;

    public StaxReader(ReadableDataLocation rdl) {
        this.rdl = rdl;
        this.reset();
    }

    @Override
    public void reset() {
        this.pop = false;
        this.hasDocType = false;
        this.stack = new Stack();
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.supportDTD", false);
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        try {
            this.stream = this.rdl.getInputStream();
            this.streamReader = factory.createXMLStreamReader(this.stream, "UTF-8");
        }
        catch (XMLStreamException e) {
            this.close();
            throw new StaxException(e);
        }
    }

    @Override
    public boolean moveNextStartNode() {
        while (this.moveNextNode()) {
            if (!this.isStartElement()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getElementNamespace() {
        return this.streamReader.getNamespaceURI();
    }

    @Override
    public void skipCurrentNode() {
        this.skipNode();
    }

    @Override
    public boolean jumpToNode(String findNodeName) {
        return this.jumpToNode(findNodeName, null);
    }

    @Override
    public void skipNode() {
        while (this.moveNextNode()) {
            if (this.isStartElement()) {
                this.skipNode();
                continue;
            }
            return;
        }
    }

    @Override
    public boolean skipToNode(String nodeName) {
        while (this.moveNextStartNode()) {
            if (!this.getElementName().equals(nodeName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean jumpToNode(String findNodeName, String doNotProcessPastNodeName) {
        while (this.moveNextStartNode()) {
            String nodeName = this.getElementName();
            if (this.isStartElement()) {
                if (!nodeName.equals(findNodeName)) continue;
                return true;
            }
            if (doNotProcessPastNodeName == null || !nodeName.equals(doNotProcessPastNodeName)) continue;
            return false;
        }
        return false;
    }

    @Override
    public boolean skipToEndNode(String nodeName) {
        while (this.moveNextNode()) {
            if (this.isStartElement() || !this.getElementName().equals(nodeName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getAttributeValue(String attrId) {
        return this.getAttributeValue(null, attrId);
    }

    @Override
    public String getAttributeValue(String namespace, String attrId) {
        if (this.attributes == null) {
            this.getAttributes();
        }
        return this.attributes.get(attrId);
    }

    @Override
    public boolean moveNextNode() throws StaxException {
        this.attributes = null;
        this.elementName = null;
        if (this.pop) {
            this.stack.pop();
            this.pop = false;
        }
        try {
            while (this.streamReader.hasNext()) {
                int event = this.streamReader.next();
                if (event == 1) {
                    this.isStartElement = true;
                    this.elementName = this.streamReader.getLocalName();
                    this.stack.push(this.elementName);
                    return true;
                }
                if (event == 2) {
                    this.elementName = this.streamReader.getLocalName();
                    if (this.stack.isEmpty()) {
                        return false;
                    }
                    this.stack.pop();
                    this.isStartElement = false;
                    return true;
                }
                if (event != 11) continue;
                this.hasDocType = true;
            }
            return false;
        }
        catch (XMLStreamException e) {
            this.close();
            throw new StaxException(e);
        }
    }

    @Override
    public String getXMLPath() {
        StringBuilder sb = new StringBuilder();
        String concat = "";
        for (String stackEl : this.stack) {
            sb.append(concat + stackEl);
            concat = "/";
        }
        return sb.toString();
    }

    @Override
    public String getElementName() {
        return this.elementName;
    }

    @Override
    public String getElementText() {
        try {
            String string = this.streamReader.getElementText();
            return string;
        }
        catch (XMLStreamException e) {
            this.close();
            throw new StaxException(e);
        }
        finally {
            this.pop = true;
        }
    }

    @Override
    public boolean isStartElement() {
        return this.isStartElement;
    }

    @Override
    public Map<String, String> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        for (int i = 0; i < this.getAttributeCount(); ++i) {
            String attrName = this.getAttributeLocalName(i);
            this.attributes.put(attrName, this.getAttributeValue(i));
        }
        return new HashMap<String, String>(this.attributes);
    }

    @Override
    public boolean hasDocType() {
        return this.hasDocType;
    }

    @Override
    public int getAttributeCount() {
        return this.streamReader.getAttributeCount();
    }

    @Override
    public String getAttributeLocalName(int i) {
        return this.streamReader.getAttributeLocalName(i);
    }

    @Override
    public String getAttributeValue(int i) {
        return this.streamReader.getAttributeValue(i);
    }

    @Override
    public String getAttributePrefix(int i) {
        return this.streamReader.getAttributePrefix(i);
    }

    @Override
    public void close() {
        StreamUtil.closeStream(this.stream);
    }
}

