/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.xml;

import java.util.Stack;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class IndentingXMLStreamWriter
implements XMLStreamWriter {
    private Object SEEN_CURRENT_OBJECT = new Object();
    private Object ELEMENT_SEEN = new Object();
    private Object DATA_SEEN = new Object();
    private Object currentStateOfObject = this.SEEN_CURRENT_OBJECT;
    private Stack<Object> stateStack = new Stack();
    private int depthOfIndent = 0;
    private String indentChar = "\n";
    private XMLStreamWriter writer;

    public IndentingXMLStreamWriter(XMLStreamWriter writer) {
        this.writer = writer;
    }

    private void onStartElement() throws XMLStreamException {
        this.stateStack.push(this.ELEMENT_SEEN);
        this.currentStateOfObject = this.SEEN_CURRENT_OBJECT;
        if (this.depthOfIndent > 0) {
            this.writeCharacters(this.indentChar);
        }
        this.indent();
        ++this.depthOfIndent;
    }

    private void onEndElement() throws XMLStreamException {
        --this.depthOfIndent;
        if (this.currentStateOfObject == this.ELEMENT_SEEN) {
            this.writeCharacters(this.indentChar);
            this.indent();
        }
        this.currentStateOfObject = this.stateStack.pop();
    }

    private void onEmptyElement() throws XMLStreamException {
        this.currentStateOfObject = this.ELEMENT_SEEN;
        if (this.depthOfIndent > 0) {
            this.writeCharacters(this.indentChar);
        }
        this.indent();
    }

    private void indent() throws XMLStreamException {
        if (this.depthOfIndent > 0) {
            for (int i = 0; i < this.depthOfIndent; ++i) {
                this.writeCharacters("  ");
            }
        }
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.writer.writeStartDocument();
        this.writeCharacters(this.indentChar);
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        this.writer.writeStartDocument(version);
        this.writeCharacters(this.indentChar);
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.writer.writeStartDocument(encoding, version);
        this.writeCharacters(this.indentChar);
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.onStartElement();
        this.writer.writeStartElement(localName);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.onStartElement();
        this.writer.writeStartElement(namespaceURI, localName);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.onStartElement();
        this.writer.writeStartElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.onEmptyElement();
        this.writer.writeEmptyElement(namespaceURI, localName);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.onEmptyElement();
        this.writer.writeEmptyElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.onEmptyElement();
        this.writer.writeEmptyElement(localName);
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.onEndElement();
        this.writer.writeEndElement();
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.currentStateOfObject = this.DATA_SEEN;
        this.writer.writeCharacters(text);
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.currentStateOfObject = this.DATA_SEEN;
        this.writer.writeCharacters(text, start, len);
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.currentStateOfObject = this.DATA_SEEN;
        this.writer.writeCData(data);
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.writer.writeEndDocument();
    }

    @Override
    public void close() throws XMLStreamException {
        this.writer.close();
    }

    @Override
    public void flush() throws XMLStreamException {
        this.writer.flush();
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.writer.writeAttribute(localName, value);
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        this.writer.writeAttribute(prefix, namespaceURI, localName, value);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.writer.writeAttribute(namespaceURI, localName, value);
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        this.writer.writeNamespace(prefix, namespaceURI);
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.writer.writeDefaultNamespace(namespaceURI);
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        this.writer.writeComment(data);
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.writer.writeProcessingInstruction(target);
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.writer.writeProcessingInstruction(target, data);
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        this.writer.writeDTD(dtd);
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        this.writer.writeEntityRef(name);
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return this.writer.getPrefix(uri);
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.writer.setPrefix(prefix, uri);
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.writer.setDefaultNamespace(uri);
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this.writer.setNamespaceContext(context);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.writer.getNamespaceContext();
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return this.writer.getProperty(name);
    }
}

