/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.xlsx;

import io.sdmx.api.io.ReadableDataLocation;
import io.sdmx.utils.core.file.ZipUtil;
import io.sdmx.utils.core.io.StreamUtil;
import io.sdmx.utils.core.object.ObjectUtil;
import io.sdmx.utils.core.xml.StaxUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.springframework.util.Assert;

public class XLSXUtil {
    public static boolean isXlsx(byte[] bytes) {
        return XLSXUtil.isXlsx(new ByteArrayInputStream(bytes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void compare(ReadableDataLocation source, ReadableDataLocation target) throws IllegalArgumentException {
        HashSet<String> ignoreAttributes = new HashSet<String>();
        ignoreAttributes.add("width");
        ignoreAttributes.add("created");
        ignoreAttributes.add("lpwstr");
        ignoreAttributes.add("borderId");
        List<ReadableDataLocation> files = null;
        List<ReadableDataLocation> expectedFiles = null;
        try {
            files = ZipUtil.unzipFiles(target);
            expectedFiles = ZipUtil.unzipFiles(source);
            HashMap<String, ReadableDataLocation> fileMap = new HashMap<String, ReadableDataLocation>();
            for (ReadableDataLocation rdl : expectedFiles) {
                if (!rdl.getName().endsWith(".xml") || rdl.getName().endsWith("styles.xml")) continue;
                fileMap.put(rdl.getName(), rdl);
            }
            for (ReadableDataLocation rdl : files) {
                if (!rdl.getName().endsWith(".xml") || rdl.getName().endsWith("styles.xml")) continue;
                ReadableDataLocation expected = (ReadableDataLocation)fileMap.get(rdl.getName());
                Assert.notNull(expected);
                try {
                    StaxUtil.isSameXML(expected.getInputStream(), rdl.getInputStream(), ignoreAttributes, null, "width", "created", "lpwstr");
                }
                catch (Exception e) {
                    throw new RuntimeException("Files '" + rdl.getName() + "' differ: " + e.getMessage());
                    return;
                }
            }
        }
        finally {
            for (ReadableDataLocation rdl : files) {
                rdl.close();
            }
            for (ReadableDataLocation rdl : expectedFiles) {
                rdl.close();
            }
            source.close();
        }
    }

    public static boolean isXlsx(ReadableDataLocation rdl) {
        boolean bl;
        if (rdl == null) {
            return false;
        }
        InputStream is = rdl.getInputStream();
        try {
            bl = XLSXUtil.isXlsx(is);
        }
        catch (Throwable throwable) {
            StreamUtil.closeStream(is);
            throw throwable;
        }
        StreamUtil.closeStream(is);
        return bl;
    }

    public static boolean isXlsx(InputStream is) {
        if (is == null) {
            return false;
        }
        List<String> zipFileNames = null;
        try {
            zipFileNames = ZipUtil.getZipFileNames(is);
        }
        catch (Exception e) {
            return false;
        }
        if (zipFileNames == null) {
            return false;
        }
        HashSet<String> folders = new HashSet<String>();
        HashSet<String> files = new HashSet<String>();
        for (String file : zipFileNames) {
            if (file.contains("/")) {
                String[] split;
                for (String part : split = file.split("/")) {
                    if (part.contains(".")) {
                        files.add(part);
                        continue;
                    }
                    folders.add(part);
                }
                continue;
            }
            files.add(file);
        }
        if (!ObjectUtil.validCollection(files) || !ObjectUtil.validCollection(folders)) {
            return false;
        }
        boolean hasCorrectFiles = files.contains("[Content_Types].xml");
        boolean hasCorrectFolters = folders.containsAll(Arrays.asList("xl", "_rels"));
        return hasCorrectFiles && hasCorrectFolters;
    }
}

