/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.version;

import io.sdmx.api.exception.SdmxSemmanticException;
import io.sdmx.utils.core.object.ObjectUtil;
import io.sdmx.utils.core.object.StringUtil;
import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionableUtil {
    public static boolean validVersion(String version) {
        if (version == null || version.length() == 0) {
            return false;
        }
        try {
            VersionableUtil.verifyVersion(version);
        }
        catch (Throwable th) {
            return false;
        }
        return true;
    }

    private static void verifyVersion(String version) {
        if (version == null) {
            throw new IllegalArgumentException("Null version supplied.");
        }
        if (version.equals("*")) {
            return;
        }
        Pattern p = Pattern.compile("([0-9])+(\\.([0-9])+)*");
        Matcher m = p.matcher(version);
        if (!m.matches()) {
            if (version.equalsIgnoreCase("$version$")) {
                SdmxSemmanticException.disableExceptionTrace(true);
            }
            SdmxSemmanticException exception = new SdmxSemmanticException("Illegal in version supplied '" + version + "'");
            SdmxSemmanticException.disableExceptionTrace(false);
            throw exception;
        }
    }

    public static String formatVersion(String version) {
        if ((version = StringUtil.cleanString(version)) == null) {
            return null;
        }
        if (version.contains("+")) {
            StringBuilder formatted = new StringBuilder();
            String concat = "";
            for (String currentVersion : version.split("\\+")) {
                formatted.append(concat + VersionableUtil.formatVersion(currentVersion));
                concat = "+";
            }
            return formatted.toString();
        }
        if (version.equals("*")) {
            return version;
        }
        if (!ObjectUtil.validString(version)) {
            version = "1.0";
        }
        VersionableUtil.verifyVersion(version);
        if (!version.contains(".")) {
            version = version + ".0";
        } else if (version.endsWith(".")) {
            version = version + "0";
        }
        return version;
    }

    public static String incrementVersion(String version1, boolean majorIncrement) {
        String[] v1Comps = version1.split("\\.");
        Integer majorVersion = new Integer(v1Comps[0]);
        if (majorIncrement) {
            majorVersion = majorVersion + 1;
            return majorVersion + ".0";
        }
        Integer minorVersion = 0;
        if (v1Comps.length > 1) {
            minorVersion = new Integer(v1Comps[1]);
        }
        minorVersion = minorVersion + 1;
        return majorVersion + "." + minorVersion;
    }

    public static boolean isHigherVersion(String version1, String version2) {
        VersionableUtil.verifyVersion(version1);
        VersionableUtil.verifyVersion(version2);
        String[] v1Comps = version1.split("\\.");
        String[] v2Comps = version2.split("\\.");
        int limit = v1Comps.length > v2Comps.length ? v2Comps.length : v1Comps.length;
        for (int i = 0; i < limit; ++i) {
            BigDecimal part1int = new BigDecimal(v1Comps[i]);
            BigDecimal part2int = new BigDecimal(v2Comps[i]);
            int compare = part1int.compareTo(part2int);
            if (compare == 0) continue;
            return compare > 0;
        }
        return v1Comps.length > v2Comps.length;
    }

    public static boolean isHigherVersionWithBetaProvision(String version1, String version2) {
        int i;
        String[] newArr;
        VersionableUtil.verifyVersion(version1);
        VersionableUtil.verifyVersion(version2);
        String[] v1Comps = version1.split("\\.");
        String[] v2Comps = version2.split("\\.");
        if (v1Comps.length < 4 && v2Comps.length < 4) {
            return VersionableUtil.isHigherVersion(version1, version2);
        }
        if (v1Comps.length > 4) {
            throw new IllegalArgumentException("Only 4 part values may be supplied. The supplied argument: " + version1 + " has more than 4 parts");
        }
        if (v2Comps.length > 4) {
            throw new IllegalArgumentException("Only 4 part values may be supplied. The supplied argument: " + version2 + " has more than 4 parts");
        }
        if (v1Comps.length < 4) {
            newArr = new String[3];
            for (i = 0; i < 3; ++i) {
                newArr[i] = i < v1Comps.length ? v1Comps[i] : "0";
            }
            v1Comps = newArr;
        }
        if (v2Comps.length < 4) {
            newArr = new String[3];
            for (i = 0; i < 3; ++i) {
                newArr[i] = i < v2Comps.length ? v2Comps[i] : "0";
            }
            v2Comps = newArr;
        }
        for (int i2 = 0; i2 < 3; ++i2) {
            BigDecimal part1int = new BigDecimal(v1Comps[i2]);
            BigDecimal part2int = new BigDecimal(v2Comps[i2]);
            int compare = part1int.compareTo(part2int);
            if (compare == 0) continue;
            return compare > 0;
        }
        if (v1Comps.length != 4) {
            return true;
        }
        if (v2Comps.length != 4) {
            return false;
        }
        BigDecimal lastPart1int = new BigDecimal(v1Comps[3]);
        BigDecimal lastPart2int = new BigDecimal(v2Comps[3]);
        return lastPart1int.compareTo(lastPart2int) > 0;
    }
}

