/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.version;

import io.sdmx.api.application.IVersion;
import io.sdmx.api.exception.SdmxSemmanticException;
import java.util.ArrayList;

public class Version
implements IVersion {
    private int[] versionNumbers;
    private String asString;

    public Version(String version) {
        Integer lastPart;
        version = version.trim();
        String[] parts = version.split("\\.");
        ArrayList<Integer> versionNumbers = new ArrayList<Integer>();
        for (String part : parts) {
            try {
                versionNumbers.add(Integer.parseInt(part));
            }
            catch (NumberFormatException e) {
                throw new SdmxSemmanticException(e, version + " is not a valid version");
            }
        }
        if (versionNumbers.size() == 1 && (lastPart = (Integer)versionNumbers.get(versionNumbers.size() - 1)) != 0) {
            versionNumbers.add(0);
        }
        StringBuilder sb = new StringBuilder();
        String concat = "";
        this.versionNumbers = new int[versionNumbers.size()];
        int i = 0;
        for (Integer currentVersion : versionNumbers) {
            this.versionNumbers[i] = currentVersion;
            ++i;
            sb.append(concat + currentVersion);
            concat = ".";
        }
        this.asString = sb.toString();
    }

    public boolean isHigher(IVersion that) {
        int min = Math.min(this.versionNumbers.length, that.getVersionLength());
        for (int i = 0; i < min; ++i) {
            int vThat;
            int vThis = this.getVersion(i);
            if (vThis > (vThat = that.getVersion(i))) {
                return true;
            }
            if (vThis >= vThat) continue;
            return false;
        }
        if (this.versionNumbers.length > that.getVersionLength()) {
            return true;
        }
        if (this.versionNumbers.length < that.getVersionLength()) {
            return false;
        }
        return false;
    }

    public String getVersion() {
        return this.asString;
    }

    @Override
    public int getVersionLength() {
        return this.versionNumbers.length;
    }

    @Override
    public int getVersion(int part) {
        return this.versionNumbers[part];
    }

    @Override
    public int compareTo(IVersion that) {
        int min = Math.min(this.getVersionLength(), that.getVersionLength());
        for (int i = 0; i < min; ++i) {
            int vThat;
            int vThis = this.getVersion(i);
            if (vThis > (vThat = that.getVersion(i))) {
                return 1;
            }
            if (vThis >= vThat) continue;
            return -1;
        }
        if (this.versionNumbers.length > that.getVersionLength()) {
            return 1;
        }
        if (this.versionNumbers.length < that.getVersionLength()) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Version) {
            Version that = (Version)obj;
            return that.getVersion().equals(this.getVersion());
        }
        return false;
    }

    public int hashCode() {
        return this.asString.hashCode();
    }

    @Override
    public String toString() {
        return this.asString;
    }
}

