/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.timer;

public abstract class TimeoutRequest<T> {
    protected abstract T runRequest();

    public final T runRequest(int timeoutMillis) {
        RequestRunner runner = new RequestRunner();
        Thread t = new Thread(runner);
        t.start();
        int i = 0;
        int sleepMillis = 500;
        while (!runner.hasResponse()) {
            if (runner.isError()) {
                throw new RuntimeException(runner.getThrowable());
            }
            ++i;
            try {
                Thread.sleep(sleepMillis);
            }
            catch (InterruptedException e) {
                return null;
            }
            if (i * sleepMillis <= timeoutMillis) continue;
            return null;
        }
        return runner.getResponse();
    }

    private class RequestRunner
    implements Runnable {
        private T response;
        private Throwable th;

        private RequestRunner() {
        }

        @Override
        public void run() {
            try {
                this.response = TimeoutRequest.this.runRequest();
            }
            catch (Throwable th) {
                this.th = th;
            }
        }

        public boolean hasResponse() {
            return this.response != null;
        }

        public boolean isError() {
            return this.th != null;
        }

        public T getResponse() {
            return this.response;
        }

        public Throwable getThrowable() {
            return this.th;
        }
    }
}

