/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.timer;

import java.time.Instant;
import java.util.Date;
import java.util.EnumMap;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimedExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(TimedExecutor.class);
    private volatile ScheduledExecutorService scheduler;
    private volatile ScheduledFuture<?> scheduleExecutor;
    private volatile Thread executorListenr;
    private Map<LISTEN_OPTS, Consumer<ScheduledFuture<?>>> listeners;
    private Runnable task;
    private long duration;
    private TimeUnit unit;
    private Date dateOnExecution;

    public TimedExecutor(long duration, TimeUnit unit, Runnable task) {
        if (duration < 0L) {
            throw new IllegalArgumentException("duation canot be a negative");
        }
        this.duration = duration;
        this.unit = unit;
        this.task = task;
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.listeners = new EnumMap(LISTEN_OPTS.class);
        Instant newDate = Instant.now();
        newDate = newDate.plusMillis(duration);
        this.dateOnExecution = Date.from(newDate);
    }

    public TimedExecutor(Date whenToWake, Runnable task) {
        this(whenToWake.getTime() - new Date().getTime(), TimeUnit.MILLISECONDS, task);
        this.dateOnExecution = whenToWake;
    }

    public Date getDuationFull() {
        return this.dateOnExecution;
    }

    public void addMethod(Runnable method) {
        this.scheduler.submit(method);
    }

    public long getRemainingDelay(TimeUnit format) {
        if (!this.isRunning()) {
            throw new IllegalStateException("Start must be called before this method");
        }
        if (format == null) {
            format = TimeUnit.MILLISECONDS;
        }
        return this.scheduleExecutor.getDelay(format);
    }

    public void start() {
        Consumer<ScheduledFuture<?>> beforeStart = this.listeners.get((Object)LISTEN_OPTS.BEFORE_START);
        if (beforeStart != null) {
            beforeStart.accept(null);
        }
        this.scheduleExecutor = this.scheduler.schedule(this.task, this.duration, this.unit);
        Consumer<ScheduledFuture<?>> afterStart = this.listeners.get((Object)LISTEN_OPTS.AFTER_START);
        if (afterStart != null) {
            afterStart.accept(this.scheduleExecutor);
        }
        Runnable threadConstraint = () -> {
            if (this.scheduleExecutor == null) return;
            try {
                do {
                    Thread.sleep(1000L);
                    if (this.scheduler.isTerminated() || this.scheduleExecutor == null) return;
                } while (!this.scheduleExecutor.isDone());
                this.shutDown(false);
                return;
            }
            catch (Throwable e) {
                this.shutDown(false);
            }
        };
        this.executorListenr = new Thread(threadConstraint, "Time executor watcher thread " + UUID.randomUUID().toString());
        this.executorListenr.start();
    }

    public void stop() {
        this.shutDown(true);
    }

    private void reset() {
        if (this.executorListenr != null) {
            this.executorListenr.interrupt();
        }
        this.scheduleExecutor = null;
        this.dateOnExecution = null;
        this.executorListenr = null;
    }

    public void shutDown(boolean force) {
        if (this.scheduleExecutor != null) {
            Consumer<ScheduledFuture<?>> beforeShutDown = this.listeners.get((Object)LISTEN_OPTS.BEFORE_SHUTDOWN);
            if (beforeShutDown != null) {
                beforeShutDown.accept(this.scheduleExecutor);
            }
            if (force || this.scheduler.isShutdown() && !this.scheduler.isTerminated()) {
                this.scheduler.shutdownNow();
            } else {
                this.scheduler.shutdown();
            }
            Consumer<ScheduledFuture<?>> afterShutDown = this.listeners.get((Object)LISTEN_OPTS.AFTER_SHUTDOWN);
            if (afterShutDown != null) {
                afterShutDown.accept(null);
            }
            LOG.info("The Timer for: '" + this.dateOnExecution + "' has been shut down");
            this.reset();
        }
    }

    public boolean isRunning() {
        return this.scheduleExecutor != null && !this.scheduler.isShutdown();
    }

    public void attachListener(LISTEN_OPTS op, Consumer<ScheduledFuture<?>> func) {
        if (this.isRunning()) {
            throw new IllegalStateException("Unable to attach listener, as the timer has already started");
        }
        this.listeners.put(op, func);
    }

    public static void main(String[] args) throws InterruptedException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        Date time = gregorianCalendar.getTime();
        System.out.println(time);
    }

    public static enum LISTEN_OPTS {
        BEFORE_SHUTDOWN,
        BEFORE_START,
        AFTER_SHUTDOWN,
        AFTER_START;

    }
}

