/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.thread;

import io.sdmx.api.http.ClientRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class ThreadLocalUtil {
    public static final String CLIENT_REQUEST = "CLIENT_REQUEST";
    public static final String SESSION = "SESSION";
    public static final String WEB_SERVICE_TYPE = "WEB_SERVICE_TYPE";
    public static final String ACTION = "ACTION";
    public static final String UUID_KEY = "UUID";
    public static final String REQUEST_ORIGIN = "REQUEST_ORIGIN";
    private static LocalObjectStore localObjectStore = new LocalObjectStore();

    private ThreadLocalUtil() {
    }

    public static void createUID() {
        ThreadLocalUtil.storeOnThread(UUID_KEY, UUID.randomUUID().toString());
    }

    public static void removeUID() {
        ThreadLocalUtil.retrieveFromThread(UUID_KEY);
    }

    public static String getUID() {
        if (ThreadLocalUtil.contains(UUID_KEY)) {
            return (String)((Map)localObjectStore.get()).get(UUID_KEY);
        }
        return null;
    }

    public static void storeClientRequest(ClientRequest clientRequest) {
        ThreadLocalUtil.storeOnThread(CLIENT_REQUEST, clientRequest);
    }

    public static ClientRequest getClientRequest() {
        if (ThreadLocalUtil.contains(CLIENT_REQUEST)) {
            return (ClientRequest)((Map)localObjectStore.get()).get(CLIENT_REQUEST);
        }
        return null;
    }

    public static void storeOnThread(Object key, Object obj) {
        ((Map)localObjectStore.get()).put(key, obj);
    }

    public static Object retrieveFromThread(Object key) {
        return ((Map)localObjectStore.get()).get(key);
    }

    public static boolean contains(Object key) {
        return ((Map)localObjectStore.get()).containsKey(key);
    }

    public static void clearFromThread(Object key) {
        ((Map)localObjectStore.get()).remove(key);
    }

    public static void clearThread() {
        ((Map)localObjectStore.get()).clear();
    }

    public static Map<Object, Object> getThreadContents() {
        return new HashMap<Object, Object>((Map)localObjectStore.get());
    }

    public static void close() {
        localObjectStore = null;
    }

    private static class LocalObjectStore
    extends ThreadLocal<Map<Object, Object>> {
        private LocalObjectStore() {
        }

        @Override
        public Map<Object, Object> initialValue() {
            return new HashMap<Object, Object>();
        }
    }
}

