/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.thread;

import io.sdmx.utils.core.logging.LoggingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Lockable {
    Logger LOG = LoggerFactory.getLogger(Lockable.class);
    private boolean isLocked = false;
    private String lockOwner;
    private int lockCount = 0;

    public synchronized void lock() {
        if (this.isLocked && this.lockOwner != null && this.lockOwner.equals(Thread.currentThread().getName())) {
            ++this.lockCount;
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("Lockable Class " + this.getClass().getName() + " - Lock requested from thread that already owns lock (" + Thread.currentThread().getName() + "), lock count = " + this.lockCount);
            }
            return;
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Lockable Class " + this.getClass().getName() + " - Aquire new lock : " + Thread.currentThread().getName());
        }
        if (this.isLocked) {
            do {
                try {
                    this.wait();
                }
                catch (Exception e) {
                    throw new RuntimeException("Error while trying to lock synchronized object");
                }
            } while (this.isLocked);
        }
        this.isLocked = true;
        this.lockCount = 0;
        this.lockOwner = Thread.currentThread().getName();
    }

    public synchronized void releaseLock(boolean fullRelease) {
        if (!this.isLocked) {
            return;
        }
        if (!Thread.currentThread().getName().equals(this.lockOwner)) {
            throw new RuntimeException("Lockable Class " + this.getClass().getName() + " releaseLock call from Thread " + Thread.currentThread().getName() + " is attempting to release a lock owned by " + this.lockOwner);
        }
        LoggingUtil.debug(this.LOG, "Release Lock Request:" + Thread.currentThread().getName());
        if (this.isLocked) {
            if (fullRelease) {
                LoggingUtil.debug(this.LOG, "Full Release");
                this.lockCount = 0;
                this.isLocked = false;
                this.notify();
            } else {
                if (this.lockCount <= 0) {
                    LoggingUtil.debug(this.LOG, "Lock Count " + this.lockCount + " Release Lock");
                    this.isLocked = false;
                    this.lockOwner = null;
                    this.notify();
                }
                LoggingUtil.debug(this.LOG, "Lock Count " + this.lockCount + " Decrease Count Value by 1");
                --this.lockCount;
            }
        }
    }

    public synchronized boolean isLocked() {
        return this.isLocked;
    }
}

