/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.thread;

import io.sdmx.utils.core.thread.ThreadLocalUtil;
import java.util.Map;

public abstract class AbstractFusionRunnable
implements Runnable {
    private Map<Object, Object> localThreadContents;

    public AbstractFusionRunnable() {
        this(true);
    }

    public AbstractFusionRunnable(boolean copyThreadLocal) {
        if (copyThreadLocal) {
            this.localThreadContents = ThreadLocalUtil.getThreadContents();
        }
    }

    @Override
    public final void run() {
        try {
            if (this.localThreadContents != null) {
                for (Object o : this.localThreadContents.keySet()) {
                    ThreadLocalUtil.storeOnThread(o, this.localThreadContents.get(o));
                }
            }
            this.runInternal();
        }
        finally {
            ThreadLocalUtil.clearThread();
        }
    }

    protected abstract void runInternal();
}

