/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.test;

import io.sdmx.api.io.ReadableDataLocation;
import io.sdmx.utils.core.file.ZipUtil;
import io.sdmx.utils.core.io.InMemoryReadableDataLocation;
import io.sdmx.utils.core.xml.StaxUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class XLSXTestUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertSameXLSX(byte[] actualOuptut, String expectedFile) {
        HashSet<String> ignoreAttributes = new HashSet<String>();
        ignoreAttributes.add("width");
        ignoreAttributes.add("created");
        ignoreAttributes.add("lpwstr");
        ignoreAttributes.add("borderId");
        List<ReadableDataLocation> files = null;
        InMemoryReadableDataLocation expectedRDL = new InMemoryReadableDataLocation(expectedFile);
        List<ReadableDataLocation> expectedFiles = null;
        try {
            files = ZipUtil.unzipFiles(new InMemoryReadableDataLocation(actualOuptut));
            expectedFiles = ZipUtil.unzipFiles(expectedRDL);
            HashMap<String, ReadableDataLocation> fileMap = new HashMap<String, ReadableDataLocation>();
            for (ReadableDataLocation rdl : expectedFiles) {
                if (!rdl.getName().endsWith(".xml") || rdl.getName().endsWith("styles.xml")) continue;
                fileMap.put(rdl.getName(), rdl);
            }
            for (ReadableDataLocation rdl : files) {
                if (!rdl.getName().endsWith(".xml") || rdl.getName().endsWith("styles.xml")) continue;
                ReadableDataLocation expected = (ReadableDataLocation)fileMap.get(rdl.getName());
                if (expected == null) {
                    throw new RuntimeException("expected file is null");
                }
                try {
                    StaxUtil.isSameXML(expected.getInputStream(), rdl.getInputStream(), ignoreAttributes, null, "width", "created", "lpwstr");
                }
                catch (Exception e) {
                    throw new RuntimeException("Files '" + rdl.getName() + "' differ: " + e.getMessage());
                }
            }
        }
        catch (Throwable throwable) {
            for (ReadableDataLocation rdl : files) {
                rdl.close();
            }
            for (ReadableDataLocation rdl : expectedFiles) {
                rdl.close();
            }
            expectedRDL.close();
            throw throwable;
        }
        for (ReadableDataLocation rdl : files) {
            rdl.close();
        }
        for (ReadableDataLocation rdl : expectedFiles) {
            rdl.close();
        }
        expectedRDL.close();
    }
}

