/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.spring;

import io.sdmx.api.application.ApplicationStartupAware;
import io.sdmx.api.application.IFusionContainer;
import io.sdmx.api.application.ISingletonContainer;
import io.sdmx.utils.core.application.FusionBeanStore;
import io.sdmx.utils.core.application.SingletonStore;
import java.util.Collection;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringBeansContainer
implements ISingletonContainer,
IFusionContainer,
ApplicationContextAware,
ApplicationStartupAware {
    private ApplicationContext CTX;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.CTX = applicationContext;
        SingletonStore.setContainer(this);
        SingletonStore.checkFutures();
        FusionBeanStore.setContainer(this);
    }

    @Override
    public void applicationRestarting() {
    }

    @Override
    public void applicationStarted() {
    }

    @Override
    public Class[] getDependsOn() {
        return null;
    }

    @Override
    public <T> Collection<T> getBeans(Class<T> type) {
        return this.CTX.getBeansOfType(type).values();
    }

    @Override
    public <T> T getSingleton(Class<T> type) throws BeansException {
        try {
            return (T)this.CTX.getBean(type);
        }
        catch (NoUniqueBeanDefinitionException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (Throwable th) {
            return null;
        }
    }

    @Override
    public <T> T getSingleton(Class<T> type, String name) {
        try {
            return (T)this.CTX.getBean(name, type);
        }
        catch (Throwable th) {
            return null;
        }
    }
}

