/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.security;

import io.sdmx.api.security.ISecurityAdminFunction;
import io.sdmx.api.security.ISecurityAdminFunctionRetreivalManager;
import io.sdmx.utils.core.application.SingletonStore;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SecurityAdminFunction
implements ISecurityAdminFunction {
    private String id;
    private String name;
    private String description;
    private Set<String> parentFunctions = Collections.emptySet();

    public static SecurityAdminFunction getInstance(String id, String name, String description, ISecurityAdminFunction ... parentFunctions) {
        return new SecurityAdminFunction(id, name, description, parentFunctions);
    }

    private SecurityAdminFunction(String id, String name, String description, ISecurityAdminFunction ... parentFunctions) {
        this.id = id;
        this.name = name;
        this.description = description;
        SingletonStore.registerInterest(ISecurityAdminFunctionRetreivalManager.class, instance -> instance.registerAdminFunction(this));
        if (parentFunctions != null) {
            this.parentFunctions = new HashSet<String>(parentFunctions.length);
            for (ISecurityAdminFunction parentFunction : parentFunctions) {
                if (parentFunction == null) continue;
                this.parentFunctions.add(parentFunction.getId());
            }
            this.parentFunctions = Collections.unmodifiableSet(this.parentFunctions);
        }
    }

    @Override
    public Set<String> parentFunctionIds() {
        return this.parentFunctions;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SecurityAdminFunction) {
            SecurityAdminFunction that = (SecurityAdminFunction)obj;
            return this.getId().equals(that.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.id;
    }
}

