/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.security;

import io.sdmx.api.process.IProcess;
import io.sdmx.api.security.ISecureThread;
import io.sdmx.api.security.ISecurityContextHolder;
import io.sdmx.api.security.SecurityDetails;
import io.sdmx.utils.core.thread.ThreadLocalUtil;
import java.util.Map;

public class FusionSecurityContext {
    private static ISecurityContextHolder securityContextHolder = new ISecurityContextHolder(){

        @Override
        public SecurityDetails getSecurityDetails() {
            return null;
        }

        @Override
        public boolean isAuthenticated() {
            return false;
        }

        @Override
        public void runAsRoot(IProcess process) {
            process.runProcess();
        }

        @Override
        public void runAsUser(SecurityDetails sd, IProcess process) {
            process.runProcess();
        }

        @Override
        public ISecureThread createSecureThread(final boolean copyThreadLocal) {
            return new ISecureThread(){
                private Map<Object, Object> localThreadContents;
                private IProcess process;

                @Override
                public void run() {
                    if (this.localThreadContents != null) {
                        for (Object o : this.localThreadContents.keySet()) {
                            ThreadLocalUtil.storeOnThread(o, this.localThreadContents.get(o));
                        }
                    }
                    try {
                        this.process.runProcess();
                    }
                    finally {
                        ThreadLocalUtil.clearThread();
                    }
                }

                @Override
                public void runProcess(IProcess process) {
                    if (copyThreadLocal) {
                        this.localThreadContents = ThreadLocalUtil.getThreadContents();
                    }
                    this.process = process;
                    Thread t = new Thread(this);
                    t.setDaemon(true);
                    t.start();
                }
            };
        }
    };

    public static void setSecurityContextHolder(ISecurityContextHolder holder) {
        securityContextHolder = holder;
    }

    public static ISecurityContextHolder CTX() {
        return securityContextHolder;
    }
}

