/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.security;

import io.sdmx.api.exception.SdmxException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CryptUtil {
    private static int KEY_SIZE;
    private static final Log logger;

    public static String encrypt(String toEncrypt, String password, String salt) {
        try {
            return CryptUtil.encrypt(toEncrypt.getBytes(), password, salt);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String decrypt(String toDecrypt, String password, String salt) {
        try {
            return new String(CryptUtil.decrypt(toDecrypt.getBytes(), password, salt));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void encrypt(Serializable ftpLicence, String password, String salt, OutputStream os) {
        try {
            byte[] serializedBytes = CryptUtil.convertObjectToSerializedBytes(ftpLicence);
            String encrypted = CryptUtil.encrypt(serializedBytes, password, salt);
            CryptUtil.writeToStream(encrypted, os);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Serializable decrypt(InputStream is, String password, String salt) {
        try {
            byte[] encryptedSerializable = CryptUtil.readFromFile(is);
            byte[] b = CryptUtil.decrypt(encryptedSerializable, password, salt);
            Serializable obj = CryptUtil.deserialize(b);
            return obj;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static byte[] convertObjectToSerializedBytes(Serializable ftpLicence) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream os = new ObjectOutputStream(bos);
        os.writeObject(ftpLicence);
        byte[] encryptedObject = bos.toByteArray();
        os.close();
        return encryptedObject;
    }

    private static Serializable deserialize(byte[] b) throws Exception {
        ByteArrayInputStream bi = new ByteArrayInputStream(b);
        ObjectInputStream si = new ObjectInputStream(bi);
        Serializable obj = (Serializable)si.readObject();
        return obj;
    }

    private static String encrypt(byte[] bytes, String pass, String salt) {
        try {
            Cipher aes = CryptUtil.getCipher(true, pass, salt);
            return CryptUtil.base64Encode(aes.doFinal(bytes));
        }
        catch (Throwable th) {
            throw new SdmxException(th, "Encryption Failed");
        }
    }

    private static byte[] decrypt(byte[] byteArray, String pass, String salt) {
        try {
            Cipher aes = CryptUtil.getCipher(false, pass, salt);
            String aString = new String(byteArray, "UTF-8");
            return aes.doFinal(CryptUtil.base64Decode(aString));
        }
        catch (Throwable th) {
            throw new SdmxException(th, "Decryption Failed");
        }
    }

    private static Cipher getCipher(boolean isEncrypt, String password, String salt) {
        PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt.getBytes(), 1000, KEY_SIZE);
        SecretKeyFactory skf = CryptUtil.getSecretKeyFactory();
        try {
            SecretKeySpec key = new SecretKeySpec(skf.generateSecret(spec).getEncoded(), "AES");
            Cipher aes = Cipher.getInstance("AES");
            aes.init(isEncrypt ? 1 : 2, key);
            return aes;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static SecretKeyFactory getSecretKeyFactory() {
        try {
            return SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static void writeToStream(String aStr, OutputStream os) throws Exception {
        PrintWriter out = new PrintWriter(os);
        out.println(aStr);
        out.close();
    }

    private static byte[] readFromFile(InputStream is) throws Exception {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        is.close();
        return buffer.toByteArray();
    }

    private static String base64Encode(byte[] bytes) {
        Base64.Encoder encoder = Base64.getEncoder();
        byte[] encoded = encoder.encode(bytes);
        return new String(encoded);
    }

    private static byte[] base64Decode(String property) throws IOException {
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] decoded = decoder.decode(property);
        return decoded;
    }

    static {
        logger = LogFactory.getLog(CryptUtil.class);
        KEY_SIZE = 256;
        String keyString = System.getProperty("KeySize");
        if (keyString != null) {
            try {
                int keyInt;
                KEY_SIZE = keyInt = Integer.parseInt(keyString);
            }
            catch (Throwable Th) {
                logger.error("Invalid Key Size for AES. Defaulting to 256.");
            }
        }
    }
}

