/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.resource;

import io.sdmx.api.exception.SdmxException;
import io.sdmx.api.lang.MessageResolver;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Service;

@Service
public class MessageDecoder
implements MessageResolver {
    private static ResourceBundleMessageSource messageSource;
    private static Set<String> baseNames;
    private static Locale loc;

    public MessageDecoder() {
        SdmxException.setMessageResolver(this);
    }

    @Override
    public String resolveMessage(String messageCode, Locale locale, Object ... args) {
        try {
            return messageSource.getMessage(messageCode, args, locale);
        }
        catch (Throwable th) {
            return messageCode;
        }
    }

    public static String decodeMessage(String id, Object ... args) {
        if (messageSource == null) {
            return id;
        }
        return messageSource.getMessage(id, args, loc);
    }

    public static String decodeMessageDefaultLocale(String id, Object ... args) {
        return messageSource.getMessage(id, args, loc);
    }

    public static String decodeMessageGivenLocale(String id, String lang, Object ... args) {
        if (messageSource == null) {
            return id;
        }
        return messageSource.getMessage(id, args, loc);
    }

    public static ResourceBundleMessageSource getMessageSource() {
        return messageSource;
    }

    public static void addBaseName(String baseName) {
        if (messageSource == null) {
            messageSource = new ResourceBundleMessageSource();
        }
        baseNames.add(baseName);
        messageSource.setBasenames(baseNames.toArray(new String[baseNames.size()]));
    }

    public void setBasenames(Set<String> basenames) {
        for (String baseName : basenames) {
            MessageDecoder.addBaseName(baseName);
        }
    }

    static {
        baseNames = new HashSet<String>();
        loc = new Locale("en");
        messageSource = new ResourceBundleMessageSource();
        messageSource.setBasename("exception");
        baseNames.add("exception");
    }
}

