/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.regex;

import io.sdmx.utils.core.object.ObjectUtil;
import java.util.regex.Pattern;

public class RegexUtil {
    private static final Pattern captureGroupPtn = Pattern.compile("\\\\[1-9][0-9]*");

    public static boolean hasCaptureGroup(String str) {
        if (!ObjectUtil.validString(str)) {
            return false;
        }
        return captureGroupPtn.matcher(str).find();
    }

    public static Pattern wildcardToRegEx(String str, String wildcard) {
        if (!wildcard.equals(".")) {
            str = str.replaceAll("\\.", "[.]");
        }
        if (!wildcard.equals("*")) {
            str = str.replaceAll("\\*", "[*]");
        }
        str = str.replaceAll("\\" + wildcard, ".*");
        return Pattern.compile(str);
    }
}

