/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.reflection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class ReflectUtil<T> {
    public Set<T> getCompositeObjects(Class referencedClass, Object o, Method ... ignoreMethods) {
        HashSet<Object> returnSet = new HashSet<Object>();
        try {
            block3: for (Method currentMethod : o.getClass().getMethods()) {
                Object claz;
                Class<?> returnClass = currentMethod.getReturnType();
                if (this.contains(currentMethod, ignoreMethods) || !ReflectUtil.isGetter(currentMethod)) continue;
                if (Collection.class.isAssignableFrom(returnClass)) {
                    Type[] typeArguments;
                    Type returnType = currentMethod.getGenericReturnType();
                    if (!(returnType instanceof ParameterizedType)) continue;
                    ParameterizedType type = (ParameterizedType)returnType;
                    for (Type typeArgument : typeArguments = type.getActualTypeArguments()) {
                        Class typeArgClass;
                        TypeVariable typeVariable;
                        if (typeArgument instanceof Class) {
                            Class typeArgClass2 = (Class)typeArgument;
                            if (!referencedClass.isAssignableFrom(typeArgClass2)) continue;
                            Collection colection = (Collection)currentMethod.invoke(o, new Object[0]);
                            if (colection == null) continue block3;
                            returnSet.addAll(colection);
                            continue block3;
                        }
                        if (!(typeArgument instanceof TypeVariable) || !((typeVariable = (TypeVariable)typeArgument).getGenericDeclaration() instanceof Class) || !referencedClass.isAssignableFrom(typeArgClass = (Class)typeVariable.getGenericDeclaration())) continue;
                        Collection colection = (Collection)currentMethod.invoke(o, new Object[0]);
                        if (colection == null) continue block3;
                        returnSet.addAll(colection);
                        continue block3;
                    }
                    continue;
                }
                if (!referencedClass.isAssignableFrom(returnClass) || (claz = currentMethod.invoke(o, new Object[0])) == null) continue;
                returnSet.add(claz);
            }
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return returnSet;
    }

    private boolean contains(Method mthd, Method[] mds) {
        if (mds == null) {
            return false;
        }
        for (Method currentMethod : mds) {
            if (!currentMethod.getName().equals(mthd.getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isGetter(Method method) {
        if (!method.getName().startsWith("get")) {
            return false;
        }
        if (method.getParameterTypes().length != 0) {
            return false;
        }
        return !Void.TYPE.equals(method.getReturnType());
    }
}

