/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.reflection;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractObjectProxy
implements InvocationHandler {
    private final Map<String, Method> methods = new HashMap<String, Method>();
    protected Object target;

    public AbstractObjectProxy(Object target) {
        this.target = target;
        for (Method method : target.getClass().getDeclaredMethods()) {
            method.setAccessible(true);
            this.methods.put(method.getName() + method.getParameterCount(), method);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        methodName = args == null ? methodName + "0" : methodName + args.length;
        Method m = this.methods.get(methodName);
        if (m == null) {
            return method.invoke(this.target, args);
        }
        return m.invoke(this.target, args);
    }
}

