/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.process;

import io.sdmx.api.notification.SimpleListener;
import io.sdmx.api.process.Processor;
import io.sdmx.api.process.Stoppable;
import io.sdmx.utils.core.process.AbstractStoppableProcessor;
import io.sdmx.utils.core.process.QueueableProcess;
import io.sdmx.utils.core.security.FusionSecurityContext;
import io.sdmx.utils.core.thread.ThreadLocalUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QueueableProcessor<K>
extends AbstractStoppableProcessor
implements Runnable,
Stoppable,
Processor,
SimpleListener {
    private static final Logger LOG = LoggerFactory.getLogger(QueueableProcessor.class);
    private String processorName;
    private BlockingQueue<K> itemsToProcess;
    private Map<K, LocalProcess> processMap = Collections.synchronizedMap(new HashMap());
    protected Thread aThread;
    private boolean shutdownRequested;

    public QueueableProcessor(String processorName) {
        this.processorName = processorName;
        this.itemsToProcess = new LinkedBlockingQueue<K>();
        this.addListener(this);
        this.startThread();
    }

    private void startThread() {
        LOG.info("Start QueueableProcessor: " + this.getProcessorName());
        this.aThread = new Thread(this);
        this.aThread.start();
    }

    public String getProcessorName() {
        return this.processorName;
    }

    public QueueableProcess placeInQueue(QueueableProcess process, K queueItem) {
        if (queueItem == null) {
            LOG.warn("place item in queue fails as item was null");
            return process;
        }
        LOG.debug("Place item in queue");
        process.acknowledgeProcess();
        process.joinQueue();
        this.processMap.put(queueItem, new LocalProcess(process));
        this.itemsToProcess.add(queueItem);
        return process;
    }

    @Override
    public void shutdownRequest() {
        this.shutdownRequested = true;
        if (!this.isProcessing()) {
            this.aThread.interrupt();
            this.shutdownRequested = false;
            this.shutdownComplete();
        }
    }

    @Override
    public void startupRequest() {
        this.aThread = new Thread((Runnable)this, UUID.randomUUID().toString());
        this.aThread.start();
        this.startupComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke() {
        if (this.getStoppableStatus() == Stoppable.STOPPABLE_STATUS.STARTED && !this.isProcessing()) {
            Thread thread = this.aThread;
            synchronized (thread) {
                this.aThread.notify();
            }
        }
        if (this.shutdownRequested && !this.isProcessing()) {
            this.shutdownRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object stufftoProcess = null;
        LocalProcess localProcess = null;
        try {
            while (true) {
                K k = this.itemsToProcess.take();
                stufftoProcess = k;
                if (k == null) break;
                QueueableProcessor queueableProcessor = this;
                synchronized (queueableProcessor) {
                    if (!this.isProcessing()) {
                        this.startProcessor();
                    }
                }
                localProcess = this.processMap.remove(stufftoProcess);
                if (localProcess == null) continue;
                QueueableProcess process = localProcess.getProcess();
                LocalProcess toRun = localProcess;
                Object toProcess = stufftoProcess;
                FusionSecurityContext.CTX().runAsUser(process.getSeurityDetails(), () -> {
                    LOG.debug("Take item from queue");
                    process.startProcess();
                    try {
                        toRun.copyThreadLocal();
                        this.process(process, toProcess);
                        process.endProcess();
                    }
                    catch (Throwable th) {
                        process.setError(th);
                    }
                    finally {
                        ThreadLocalUtil.clearThread();
                        this.stopProcessor();
                    }
                });
            }
        }
        catch (InterruptedException e) {
            LOG.error("InterruptedException on QueueableProcessor - Stop Processor");
            this.stopProcessor();
            LOG.error("InterruptedException on QueueableProcessor - place item back onto queue and restart thread");
            if (stufftoProcess != null) {
                this.itemsToProcess.add(stufftoProcess);
                this.processMap.put(stufftoProcess, localProcess);
            }
            this.startThread();
        }
        catch (Throwable th) {
            this.stopProcessor();
            LOG.error("QueueableProcessor Exception - restart thread", th);
            this.startProcessor();
            this.startThread();
        }
    }

    protected abstract void process(QueueableProcess var1, K var2);

    private class LocalProcess {
        private Map<Object, Object> threadLocal = ThreadLocalUtil.getThreadContents();
        private QueueableProcess process;

        public LocalProcess(QueueableProcess process) {
            this.process = process;
        }

        public void copyThreadLocal() {
            for (Object o : this.threadLocal.keySet()) {
                ThreadLocalUtil.storeOnThread(o, this.threadLocal.get(o));
            }
        }

        public QueueableProcess getProcess() {
            return this.process;
        }
    }
}

