/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.process;

import io.sdmx.api.notification.Listener;
import io.sdmx.api.notification.Notifier;
import io.sdmx.api.security.SecurityDetails;
import io.sdmx.utils.core.audit.AuditUtil;
import io.sdmx.utils.core.error.ErrorReport;
import io.sdmx.utils.core.notifier.ThreadedNotifier;
import io.sdmx.utils.core.process.QueueableNotification;
import io.sdmx.utils.core.security.FusionSecurityContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public class QueueableProcess
implements Notifier<QueueableNotification> {
    private String id;
    private Date processRequestTime;
    private Date processQueueTime;
    private Date processStartTime;
    private Date processEndTime;
    private PROCESS_STATUS currentStatus;
    private int percentComplete;
    private ErrorReport errorReport;
    private String auditId;
    private SecurityDetails sd;
    private List<Listener<QueueableNotification>> listeners = new ArrayList<Listener<QueueableNotification>>();

    private QueueableProcess() {
        this.auditId = AuditUtil.getCurrentAuditId();
        this.sd = FusionSecurityContext.CTX().getSecurityDetails();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(Listener<QueueableNotification> listener) {
        List<Listener<QueueableNotification>> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(Listener<QueueableNotification> listener) {
        List<Listener<QueueableNotification>> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void alertListenersOfChange() {
        QueueableNotification notification = new QueueableNotification(this);
        List<Listener<QueueableNotification>> list = this.listeners;
        synchronized (list) {
            for (Listener<QueueableNotification> currentListener : this.listeners) {
                ThreadedNotifier.performNotification(currentListener, notification);
            }
        }
    }

    public static QueueableProcess createNewQueueableProcess() {
        QueueableProcess process = new QueueableProcess();
        process.id = UUID.randomUUID().toString();
        process.processRequestTime = new Date();
        return process;
    }

    public void acknowledgeProcess() {
        this.currentStatus = PROCESS_STATUS.PENDING;
        this.processQueueTime = new Date();
        this.alertListenersOfChange();
    }

    public void joinQueue() {
        this.currentStatus = PROCESS_STATUS.QUEUED;
        this.processQueueTime = new Date();
        this.alertListenersOfChange();
    }

    public void startProcess() {
        this.currentStatus = PROCESS_STATUS.PROCESSING;
        this.processStartTime = new Date();
        this.alertListenersOfChange();
    }

    public void cancelProcess() {
        this.currentStatus = PROCESS_STATUS.CANCELLED;
        this.processEndTime = new Date();
        this.alertListenersOfChange();
    }

    public void endProcess() {
        this.currentStatus = PROCESS_STATUS.PROCESSED;
        this.percentComplete = 100;
        this.processEndTime = new Date();
        this.alertListenersOfChange();
    }

    public void endProcessError() {
        this.currentStatus = PROCESS_STATUS.ERROR;
        this.processEndTime = new Date();
        this.alertListenersOfChange();
    }

    public void setError(Throwable th) {
        this.errorReport = ErrorReport.build(th);
        this.endProcessError();
    }

    public String getId() {
        return this.id;
    }

    public SecurityDetails getSeurityDetails() {
        return this.sd;
    }

    public String getAuditId() {
        return this.auditId;
    }

    public void setAuditId(String auditId) {
        this.auditId = auditId;
    }

    public Date getProcessQueueTime() {
        return this.processQueueTime;
    }

    public Date getProcessRequestTime() {
        return this.processRequestTime;
    }

    public Date getProcessStartTime() {
        return this.processStartTime;
    }

    public Date getProcessEndTime() {
        return this.processEndTime;
    }

    public PROCESS_STATUS getCurrentStatus() {
        return this.currentStatus;
    }

    public void setPercentComplete(int percentComplete) {
        if (this.getCurrentStatus() != PROCESS_STATUS.PROCESSED && percentComplete > this.percentComplete) {
            this.percentComplete = percentComplete;
            this.alertListenersOfChange();
        }
    }

    public int getPercentComplete() {
        return this.percentComplete;
    }

    public ErrorReport getErrorReport() {
        return this.errorReport;
    }

    public static enum PROCESS_STATUS {
        PENDING(1),
        QUEUED(2),
        PROCESSING(3),
        PROCESSED(4),
        ERROR(5),
        CANCELLED(6);

        private int sequentialValue;

        private PROCESS_STATUS(int sequentialValue) {
            this.sequentialValue = sequentialValue;
        }

        public static PROCESS_STATUS parseInt(int val) {
            for (PROCESS_STATUS status : PROCESS_STATUS.values()) {
                if (status.sequentialValue != val) continue;
                return status;
            }
            return null;
        }

        public int getSequentialValue() {
            return this.sequentialValue;
        }

        public boolean isCancelled() {
            return this == CANCELLED;
        }

        public boolean isProcessed() {
            return this == PROCESSED;
        }

        public boolean isError() {
            return this == ERROR;
        }

        public boolean isLater(PROCESS_STATUS aStatus) {
            if (aStatus == null) {
                return true;
            }
            return this.sequentialValue >= aStatus.sequentialValue;
        }
    }
}

