/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.process;

import io.sdmx.utils.core.error.ErrorReport;
import io.sdmx.utils.core.process.QueueableProcess;
import java.util.Date;

public class QueueableNotification {
    private String id;
    private Date processRequestTime;
    private Date processQueueTime;
    private Date processStartTime;
    private Date processEndTime;
    private QueueableProcess.PROCESS_STATUS currentStatus;
    private int percentComplete;
    private ErrorReport errorReport;
    private String auditId;

    QueueableNotification(QueueableProcess process) {
        this.auditId = process.getAuditId();
        this.id = process.getId();
        if (process.getProcessRequestTime() != null) {
            this.processRequestTime = new Date(process.getProcessRequestTime().getTime());
        }
        if (process.getProcessQueueTime() != null) {
            this.processQueueTime = new Date(process.getProcessQueueTime().getTime());
        }
        if (process.getProcessStartTime() != null) {
            this.processStartTime = new Date(process.getProcessStartTime().getTime());
        }
        if (process.getProcessEndTime() != null) {
            this.processEndTime = new Date(process.getProcessEndTime().getTime());
        }
        this.currentStatus = process.getCurrentStatus();
        this.percentComplete = process.getPercentComplete();
        this.errorReport = process.getErrorReport();
    }

    public String getId() {
        return this.id;
    }

    public String getAuditId() {
        return this.auditId;
    }

    public boolean isTerminated() {
        return this.isCancelled() || this.isProcessed() || this.isError();
    }

    public boolean isCancelled() {
        return this.currentStatus.isCancelled();
    }

    public boolean isProcessed() {
        return this.currentStatus.isProcessed();
    }

    public boolean isError() {
        return this.currentStatus.isError();
    }

    public Date getProcessRequestTime() {
        return this.processRequestTime;
    }

    public Date getProcessQueueTime() {
        return this.processQueueTime;
    }

    public Date getProcessStartTime() {
        return this.processStartTime;
    }

    public Date getProcessEndTime() {
        return this.processEndTime;
    }

    public QueueableProcess.PROCESS_STATUS getCurrentStatus() {
        return this.currentStatus;
    }

    public int getPercentComplete() {
        return this.percentComplete;
    }

    public ErrorReport getErrorReport() {
        return this.errorReport;
    }
}

