/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.process;

import io.sdmx.api.process.Processor;
import io.sdmx.utils.core.process.AbstractStoppable;
import io.sdmx.utils.core.timer.Stopwatch;

public abstract class AbstractStoppableProcessor
extends AbstractStoppable
implements Processor {
    private Processor.PROCESSOR_STATUS currentProcessorStatus = Processor.PROCESSOR_STATUS.IDLE;
    private Stopwatch processorStopwatch = new Stopwatch();

    @Override
    public Processor.PROCESSOR_STATUS getProcessorStatus() {
        return this.currentProcessorStatus;
    }

    @Override
    public long getProcessorStatusRuntime() {
        return this.processorStopwatch.getDuration();
    }

    @Override
    public boolean isProcessing() {
        return this.currentProcessorStatus == Processor.PROCESSOR_STATUS.PROCESSING;
    }

    protected void startProcessor() {
        this.changeStatus(Processor.PROCESSOR_STATUS.PROCESSING);
    }

    protected void stopProcessor() {
        this.changeStatus(Processor.PROCESSOR_STATUS.IDLE);
    }

    private void changeStatus(Processor.PROCESSOR_STATUS status) {
        this.currentProcessorStatus = status;
        this.processorStopwatch.start();
        this.notifyStatusChanged();
    }
}

