/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.process;

import io.sdmx.api.exception.SdmxException;
import io.sdmx.api.notification.SimpleListener;
import io.sdmx.api.process.Stoppable;
import io.sdmx.utils.core.timer.Stopwatch;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractStoppable
implements Stoppable,
SimpleListener {
    private Stoppable.STOPPABLE_STATUS status = Stoppable.STOPPABLE_STATUS.STOPPED;
    private Stopwatch stopwatch = new Stopwatch();
    private Set<SimpleListener> listeners = new HashSet<SimpleListener>();
    private Set<Stoppable> compositeStoppables = new HashSet<Stoppable>();
    private boolean isRestartRequest;

    @Override
    public long getStatusDuration() {
        return this.stopwatch.getDuration();
    }

    @Override
    public Stoppable.STOPPABLE_STATUS getStoppableStatus() {
        return this.status;
    }

    protected void addCompositeStoppable(Stoppable stoppable) {
        this.compositeStoppables.add(stoppable);
        stoppable.addListener(this);
    }

    @Override
    public void restart() throws SdmxException {
        if (this.status == Stoppable.STOPPABLE_STATUS.STARTED) {
            this.isRestartRequest = true;
            this.shutdown();
        } else if (this.status == Stoppable.STOPPABLE_STATUS.STOPPED) {
            this.startUp();
        }
    }

    @Override
    public void shutdown() throws SdmxException {
        if (this.status == Stoppable.STOPPABLE_STATUS.STARTED) {
            this.changeStatus(Stoppable.STOPPABLE_STATUS.SHUTTING_DOWN);
            for (Stoppable currentCompositeStoppable : this.compositeStoppables) {
                currentCompositeStoppable.shutdown();
            }
            this.performShutdownChecks();
        }
    }

    @Override
    public void startUp() throws SdmxException {
        if (this.status == Stoppable.STOPPABLE_STATUS.STOPPED) {
            this.changeStatus(Stoppable.STOPPABLE_STATUS.STARTING);
            for (Stoppable currentCompositeStoppable : this.compositeStoppables) {
                currentCompositeStoppable.startUp();
            }
            this.performStartupChecks();
        }
    }

    private void performStartupChecks() {
        for (Stoppable currentCompositeStoppable : this.compositeStoppables) {
            if (currentCompositeStoppable.getStoppableStatus() == Stoppable.STOPPABLE_STATUS.STARTED) continue;
            return;
        }
        this.startupRequest();
    }

    private void performShutdownChecks() {
        for (Stoppable currentCompositeStoppable : this.compositeStoppables) {
            if (currentCompositeStoppable.getStoppableStatus() == Stoppable.STOPPABLE_STATUS.STOPPED) continue;
            return;
        }
        this.shutdownRequest();
    }

    @Override
    public void invoke() {
        if (this.status == Stoppable.STOPPABLE_STATUS.SHUTTING_DOWN) {
            this.performShutdownChecks();
        }
        if (this.status == Stoppable.STOPPABLE_STATUS.STARTING) {
            this.performStartupChecks();
        }
    }

    private void changeStatus(Stoppable.STOPPABLE_STATUS newStatus) {
        this.stopwatch.start();
        this.status = newStatus;
        this.notifyStatusChanged();
    }

    protected void notifyStatusChanged() {
        for (SimpleListener currentListener : this.listeners) {
            currentListener.invoke();
        }
    }

    protected void startupComplete() {
        this.changeStatus(Stoppable.STOPPABLE_STATUS.STARTED);
    }

    protected void shutdownComplete() {
        this.changeStatus(Stoppable.STOPPABLE_STATUS.STOPPED);
        if (this.isRestartRequest) {
            this.isRestartRequest = false;
            this.startUp();
        }
    }

    @Override
    public void addListener(SimpleListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(SimpleListener listener) {
        this.listeners.remove(listener);
    }

    protected abstract void startupRequest();

    protected abstract void shutdownRequest();
}

