/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.object;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

public class StringUtil {
    public static final String EMPTY = "";
    public static final char LF = '\n';
    public static final char CR = '\r';
    private static final Map<String, WeakReference<String>> s_manualCache = Collections.synchronizedMap(new WeakHashMap(100000));

    public static String manualIntern(String str) {
        String value;
        if (str == null) {
            return str;
        }
        WeakReference<String> cached = s_manualCache.get(str);
        if (cached != null && (value = (String)cached.get()) != null) {
            return value;
        }
        str = new String(str);
        s_manualCache.put(str, new WeakReference<String>(str));
        return str;
    }

    public static String[] manualIntern(String[] str) {
        if (str != null) {
            for (int i = 0; i < str.length; ++i) {
                str[i] = StringUtil.manualIntern(str[i]);
            }
        }
        return str;
    }

    public static String cleanString(String inputString) {
        if (inputString == null) {
            return null;
        }
        return StringUtil.manualIntern(StringUtil.removeLineBreaks(inputString).trim());
    }

    public static String stripBOM(String aString) {
        if (aString == null) {
            return null;
        }
        byte[] asBytes = aString.getBytes();
        if (asBytes.length > 1 && asBytes[0] == 63) {
            int startPos;
            for (startPos = 1; startPos < asBytes.length && asBytes[startPos] == 63; ++startPos) {
            }
            byte[] slice = Arrays.copyOfRange(asBytes, startPos, asBytes.length);
            return new String(slice);
        }
        if (asBytes.length > 2 && asBytes[0] == -2 && asBytes[1] == -1) {
            byte[] slice = Arrays.copyOfRange(asBytes, 2, asBytes.length);
            return new String(slice);
        }
        if (asBytes.length > 3 && asBytes[0] == -17 && asBytes[1] == -69 && asBytes[2] == -65) {
            byte[] slice = Arrays.copyOfRange(asBytes, 3, asBytes.length);
            return new String(slice);
        }
        if (asBytes.length > 4 && asBytes[0] == -61 && asBytes[1] == -66 && asBytes[2] == -61 && asBytes[3] == -65) {
            byte[] slice = Arrays.copyOfRange(asBytes, 4, asBytes.length);
            return new String(slice);
        }
        if (asBytes.length > 6 && asBytes[0] == -61 && asBytes[1] == -81 && asBytes[2] == -62 && asBytes[3] == -69 && asBytes[4] == -62 && asBytes[5] == -65) {
            byte[] slice = Arrays.copyOfRange(asBytes, 6, asBytes.length);
            return new String(slice);
        }
        return aString;
    }

    public static boolean hasBOM(String aString) {
        if (aString == null) {
            return false;
        }
        byte[] asBytes = aString.getBytes();
        if (asBytes.length > 1 && asBytes[0] == 63) {
            return true;
        }
        if (asBytes.length > 2 && asBytes[0] == -2 && asBytes[1] == -1) {
            return true;
        }
        if (asBytes.length > 3 && asBytes[0] == -17 && asBytes[1] == -69 && asBytes[2] == -65) {
            return true;
        }
        if (asBytes.length > 4 && asBytes[0] == -61 && asBytes[1] == -66 && asBytes[2] == -61 && asBytes[3] == -65) {
            return true;
        }
        return asBytes.length > 6 && asBytes[0] == -61 && asBytes[1] == -81 && asBytes[2] == -62 && asBytes[3] == -69 && asBytes[4] == -62 && asBytes[5] == -65;
    }

    public static String removeLineBreaks(String inputString) {
        if (inputString == null) {
            return null;
        }
        inputString = inputString.replaceAll("\\u000A", EMPTY);
        inputString = inputString.replaceAll("\\u000D", EMPTY);
        return inputString;
    }

    public static String trim(String string) {
        int last;
        int first;
        int len = string.length();
        for (first = 0; first < len && WhiteSpace.INSTANCE.matches(string.charAt(first)); ++first) {
        }
        for (last = len - 1; last > first && WhiteSpace.INSTANCE.matches(string.charAt(last)); --last) {
        }
        return string.subSequence(first, last + 1).toString();
    }

    public static String removeHorizontalLineBreaks(String inputString) {
        if (inputString == null) {
            return null;
        }
        return inputString.trim().replaceAll("(^\\h*)|(\\h*$)", EMPTY);
    }

    public static String chop(String str) {
        if (str == null) {
            return null;
        }
        int strLen = str.length();
        if (strLen < 2) {
            return EMPTY;
        }
        int lastIdx = strLen - 1;
        String ret = str.substring(0, lastIdx);
        char last = str.charAt(lastIdx);
        if (last == '\n' && ret.charAt(lastIdx - 1) == '\r') {
            return ret.substring(0, lastIdx - 1);
        }
        return ret;
    }

    public static String[] splitWithRegex(String source, String splitOn, int limit) {
        if (limit == 1) {
            return new String[]{source};
        }
        ArrayList<String> targetsList = new ArrayList<String>(5);
        StringBuilder sbx = new StringBuilder();
        char colon = splitOn.charAt(0);
        char openbracket = "[".charAt(0);
        char openparenthisis = "(".charAt(0);
        char closebracket = "]".charAt(0);
        char closeparenthisis = ")".charAt(0);
        int inbracket = 0;
        boolean limitHit = false;
        for (char c : source.toCharArray()) {
            if (!limitHit) {
                if (c == colon && inbracket == 0) {
                    targetsList.add(sbx.toString());
                    sbx = new StringBuilder();
                    limitHit = targetsList.size() == limit;
                    continue;
                }
                if (c == openbracket || c == openparenthisis) {
                    ++inbracket;
                } else if (c == closebracket || c == closeparenthisis) {
                    --inbracket;
                }
            }
            sbx.append(c);
        }
        targetsList.add(sbx.toString());
        String[] returnArray = new String[targetsList.size()];
        return targetsList.toArray(returnArray);
    }

    private static final class WhiteSpace {
        static final String WHITESPACE_CHARS = "\u2002\u3000\r\u0085\u200a\u2005\u2000\u3000\u2029\u000b\u3000\u2008\u2003\u205f\u3000\u1680\t \u2006\u2001\u202f\u00a0\f\u2009\u3000\u2004\u3000\u3000\u2028\n\u2007\u3000";
        private static final int SHIFT = Integer.numberOfLeadingZeros("\u2002\u3000\r\u0085\u200a\u2005\u2000\u3000\u2029\u000b\u3000\u2008\u2003\u205f\u3000\u1680\t \u2006\u2001\u202f\u00a0\f\u2009\u3000\u2004\u3000\u3000\u2028\n\u2007\u3000".length() - 1);
        private static final int MULTIPLIER = 1682554634;
        private static final WhiteSpace INSTANCE = new WhiteSpace();

        private WhiteSpace() {
        }

        public boolean matches(char c) {
            return WHITESPACE_CHARS.charAt(1682554634 * c >>> SHIFT) == c;
        }
    }
}

