/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.object;

import io.sdmx.api.exception.SdmxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class SeriesUtil {
    public static final String KEY_DELIMITER = ":";

    public static List<String[]> mergeWildcardedSeries(List<String[]> series) {
        if (series != null) {
            int length = -1;
            for (String[] stringArray : series) {
                if (length < 0) {
                    length = stringArray.length;
                    continue;
                }
                if (length == stringArray.length) continue;
                throw new SdmxException("mergeWildcardedSeries can not process series of varying lengths");
            }
            for (int idx = 0; idx < length; ++idx) {
                ArrayList<String[]> expanded = new ArrayList<String[]>();
                ArrayList<String[]> wildcardedForDimension = new ArrayList<String[]>();
                ArrayList<String[]> arrayList = new ArrayList<String[]>();
                for (String[] currentSeries : series) {
                    if (currentSeries[idx] == null) {
                        wildcardedForDimension.add(currentSeries);
                        continue;
                    }
                    arrayList.add(currentSeries);
                    expanded.add(currentSeries);
                }
                if (wildcardedForDimension.size() > 0 && arrayList.size() > 0) {
                    for (String[] wildcarded : wildcardedForDimension) {
                        HashSet<String> fixedCodes = new HashSet<String>();
                        for (String[] fixed : arrayList) {
                            if (!SeriesUtil.isMatch(wildcarded, fixed)) continue;
                            fixedCodes.add(fixed[idx]);
                        }
                        if (fixedCodes.size() == 0) {
                            expanded.add(wildcarded);
                            continue;
                        }
                        for (String fixedCode : fixedCodes) {
                            String[] newArr = (String[])wildcarded.clone();
                            newArr[idx] = fixedCode;
                            expanded.add(newArr);
                        }
                    }
                } else {
                    expanded.addAll(wildcardedForDimension);
                    arrayList.addAll(wildcardedForDimension);
                }
                series = expanded;
            }
        }
        HashSet<String> removeDuplicates = new HashSet<String>();
        for (String[] stringArray : series) {
            removeDuplicates.add(SeriesUtil.toSeriesKey(stringArray));
        }
        series = new ArrayList<String[]>();
        for (String string : removeDuplicates) {
            String[] split = SeriesUtil.splitKey(string);
            for (int i = 0; i < split.length; ++i) {
                if (split[i].length() != 0) continue;
                split[i] = null;
            }
            series.add(split);
        }
        return series;
    }

    public static boolean isMatch(String[] seriesA, String[] seriesB) {
        int length = seriesA.length;
        if (seriesB.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (seriesA[i] == null || seriesB[i] == null || seriesA[i].equals(seriesB[i])) continue;
            return false;
        }
        return true;
    }

    public static String[] splitKey(String series, int splitLimit) {
        boolean addLeading = series.startsWith(KEY_DELIMITER);
        boolean addTrailing = series.endsWith(KEY_DELIMITER);
        if (addLeading) {
            series = "~" + series;
        }
        if (addTrailing) {
            series = series + "~";
        }
        String[] split = series.split(KEY_DELIMITER, splitLimit);
        if (addLeading) {
            split[0] = "";
        }
        if (addTrailing) {
            split[split.length - 1] = "";
        }
        return split;
    }

    public static String[] splitKey(String series) {
        return SeriesUtil.splitKey(series, -1);
    }

    public static String collapseKey(String series, int ... collapseDimensions) {
        if (collapseDimensions == null) {
            return series;
        }
        String[] split = SeriesUtil.splitKey(series);
        for (int i : collapseDimensions) {
            if (i >= split.length) continue;
            split[i] = "";
        }
        return SeriesUtil.toSeriesKey(split);
    }

    public static String removeExplitWildcard(String series) {
        if (series.contains("*")) {
            String[] keySplit = SeriesUtil.splitKey(series);
            for (int i = 0; i < keySplit.length; ++i) {
                if (!keySplit[i].equals("*")) continue;
                keySplit[i] = "";
            }
            series = SeriesUtil.toSeriesKey(keySplit);
        }
        return series;
    }

    public static String toSeriesKey(String[] series) {
        return SeriesUtil.toSeriesKey(series, -1, "");
    }

    public static String toSeriesKey(String[] series, String replaceMissing) {
        return SeriesUtil.toSeriesKey(series, -1, replaceMissing);
    }

    public static String toSeriesKey(String[] series, int toIdx) {
        return SeriesUtil.toSeriesKey(series, toIdx, "");
    }

    public static String toSeriesKey(String[] series, int toIdx, String replaceMissing) {
        return SeriesUtil.toSeriesKey(series, toIdx, replaceMissing, null);
    }

    public static String toSeriesKey(String[] series, int toIdx, String replaceMissing, Set<Integer> wildcard) {
        if (toIdx < 0) {
            toIdx = series.length;
        } else if (toIdx > series.length) {
            toIdx = series.length;
        }
        StringBuilder sb = new StringBuilder();
        String concat = "";
        for (int i = 0; i < toIdx; ++i) {
            String val = wildcard != null && wildcard.contains(i) ? "*" : (series[i] == null ? replaceMissing : series[i]);
            sb.append(concat + val);
            concat = KEY_DELIMITER;
        }
        return sb.toString();
    }

    public static String addQuotesToShortKeyElements(String shortCode, String delimiter) {
        if (shortCode == null || !shortCode.contains(delimiter)) {
            return shortCode;
        }
        String[] split = SeriesUtil.splitKey(shortCode);
        for (int i = 0; i < split.length; ++i) {
            String aPart = split[i];
            if (!aPart.contains(delimiter)) continue;
            split[i] = "\"" + aPart + "\"";
        }
        return SeriesUtil.toSeriesKey(split);
    }

    public static Set<String> expandSeries(String wildcardedSeries, Set<String> allSeries) {
        HashSet<String> returnSet = new HashSet<String>();
        if (SeriesUtil.hasWildcards(wildcardedSeries)) {
            Pattern p = SeriesUtil.wildcardSeriesToPattern(wildcardedSeries);
            for (String series : allSeries) {
                if (!p.matcher(series).matches()) continue;
                returnSet.add(series);
            }
        } else {
            returnSet.add(wildcardedSeries);
        }
        return returnSet;
    }

    public static Pattern wildcardSeriesToPattern(String wildcardedSeries, boolean allowWildcardMatch) {
        String regExStr = "([A-Z]|[a-z]|\\\\|@|[0-9]|_|\\$|\\-|\\*)*";
        if (wildcardedSeries.endsWith(KEY_DELIMITER)) {
            wildcardedSeries = wildcardedSeries + "*";
        }
        if (wildcardedSeries.startsWith(KEY_DELIMITER)) {
            wildcardedSeries = "*" + wildcardedSeries;
        }
        StringBuilder seriesRebuild = new StringBuilder();
        String[] split = wildcardedSeries.split(KEY_DELIMITER);
        String concat = "";
        for (String currentSplit : split) {
            seriesRebuild.append(concat);
            if (currentSplit.equals("*") || currentSplit.length() == 0) {
                seriesRebuild.append(regExStr);
            } else if (currentSplit.contains("+")) {
                seriesRebuild.append("(");
                String concatBar = "";
                for (String queryParam : currentSplit.split("\\+")) {
                    seriesRebuild.append(concatBar + queryParam);
                    concatBar = "|";
                }
                if (allowWildcardMatch) {
                    seriesRebuild.append(concatBar + "\\*");
                }
                seriesRebuild.append(")");
            } else if (allowWildcardMatch) {
                seriesRebuild.append("(\\*|" + currentSplit + ")");
            } else {
                seriesRebuild.append(currentSplit);
            }
            concat = KEY_DELIMITER;
        }
        String regEx = seriesRebuild.toString();
        if (wildcardedSeries.startsWith(KEY_DELIMITER)) {
            regEx = regExStr + regEx;
        }
        if (wildcardedSeries.endsWith(KEY_DELIMITER)) {
            regEx = regEx + regExStr;
        }
        return Pattern.compile(regEx);
    }

    public static Pattern wildcardSeriesToPattern(String wildcardedSeries) {
        return SeriesUtil.wildcardSeriesToPattern(wildcardedSeries, false);
    }

    public static String toWildCardSeries(String series) {
        if (series.startsWith(KEY_DELIMITER)) {
            series = "*" + series;
        }
        if (series.endsWith(KEY_DELIMITER)) {
            series = series + "*";
        }
        return series.replaceAll("::", ":*:");
    }

    public static boolean hasWildcards(String series) {
        return SeriesUtil.isWildCardSeries(series);
    }

    public static boolean isWildCardSeries(String series) {
        if (series.contains("*")) {
            return true;
        }
        if (series.contains("+")) {
            return true;
        }
        if (series.startsWith(KEY_DELIMITER)) {
            return true;
        }
        if (series.endsWith(KEY_DELIMITER)) {
            return true;
        }
        return series.contains("::");
    }

    public static Set<String> expandSeries(String series) {
        HashSet<String> returnSet = new HashSet<String>();
        returnSet.add(series);
        boolean expand = series.contains("+");
        while (expand) {
            expand = false;
            HashSet<String> expandedSet = new HashSet<String>();
            block1: for (String currentSeries : returnSet) {
                if (!currentSeries.contains("+")) continue;
                expand = true;
                currentSeries = currentSeries + "~";
                String[] keySplit = currentSeries.split(KEY_DELIMITER);
                String lastKey = keySplit[keySplit.length - 1];
                keySplit[keySplit.length - 1] = lastKey.substring(0, lastKey.length() - 1);
                for (int x = 0; x < keySplit.length; ++x) {
                    if (!keySplit[x].contains("+")) continue;
                    String[] splitChoices = keySplit[x].split("\\+");
                    for (int xx = 0; xx < splitChoices.length; ++xx) {
                        StringBuilder sb = new StringBuilder();
                        String concat = "";
                        for (int xxx = 0; xxx < keySplit.length; ++xxx) {
                            String toAppend = xxx == x ? splitChoices[xx] : keySplit[xxx];
                            sb.append(concat + toAppend);
                            concat = KEY_DELIMITER;
                        }
                        expandedSet.add(sb.toString());
                    }
                    continue block1;
                }
            }
            if (expandedSet.size() <= 0) continue;
            returnSet = expandedSet;
        }
        return returnSet;
    }
}

