/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.object;

import io.sdmx.api.exception.SdmxSemmanticException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ObjectUtil {
    public static final String POUND_SIGN = String.valueOf('\u00a3');
    public static final String PRIVATE_USE_ONE = String.valueOf('\u2018');
    public static final String PRIVATE_USE_TWO = String.valueOf('\u2019');
    private static final String[] ALPHABET = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};

    public static void assertTrue(Boolean bool) {
        ObjectUtil.assertTrue(null, bool);
    }

    public static void assertTrue(String message, Boolean bool) {
        if (bool == null || bool != Boolean.TRUE) {
            throw new IllegalArgumentException(message != null ? message : "True Expected");
        }
    }

    public static void assertFalse(String message, Boolean bool) {
        if (bool == null || bool != Boolean.FALSE) {
            throw new IllegalArgumentException(message != null ? message : "False Expected");
        }
    }

    public static void assertFalse(Boolean bool) {
        ObjectUtil.assertFalse(null, bool);
    }

    public static void assertEquals(Object o1, Object o2) {
        ObjectUtil.assertEquals(null, o1, o2);
    }

    public static void assertCollectionEquals(Collection<?> c1, Collection<?> c2) {
        ObjectUtil.assertCollectionEquals(null, c1, c2);
    }

    public static void assertCollectionEquals(String message, Collection<?> c1, Collection<?> c2) {
        if (!ObjectUtil.equivalentCollection(c1, c2)) {
            throw new IllegalArgumentException(message != null ? message : "Collectionsa are not equal");
        }
    }

    public static void assertEquals(String message, Object o1, Object o2) {
        if (!ObjectUtil.equivalent(o1, o2)) {
            throw new IllegalArgumentException(message != null ? message : "Not equal: " + o1 + " and " + o2);
        }
    }

    public static <T> T assertNotNull(T obj) {
        return ObjectUtil.assertNotNull(null, obj);
    }

    public static <T> T assertNotNull(String message, T obj) {
        if (obj == null) {
            throw new RuntimeException(message != null ? message : "Required object is null");
        }
        return obj;
    }

    public static void assertNull(Object obj) {
        ObjectUtil.assertNotNull(null, obj);
    }

    public static void assertNull(String message, Object obj) {
        if (obj == null) {
            throw new RuntimeException(message != null ? message : "Expected null");
        }
    }

    public static String intToAlpha(int idx) {
        String letter = "";
        int major = new Double(Math.floor(idx / 26)).intValue();
        int minor = idx - major * 26;
        if (major > 0) {
            letter = letter + ALPHABET[major - 1];
        }
        letter = letter + ALPHABET[minor];
        return letter;
    }

    public static Integer toInteger(String str, Integer defaultIfNull) {
        if (!ObjectUtil.validString(str)) {
            return defaultIfNull;
        }
        if (!ObjectUtil.isInteger(str)) {
            throw new SdmxSemmanticException(str + " is not a valid Integer");
        }
        try {
            return Integer.valueOf(str);
        }
        catch (Exception e) {
            throw new SdmxSemmanticException(str + " is not a valid Integer");
        }
    }

    public static boolean isInteger(String s) {
        return ObjectUtil.isInteger(s, 10);
    }

    public static boolean isInteger(String s, int radix) {
        if (s.isEmpty()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (!(i == 0 && s.charAt(i) == '-' ? s.length() == 1 : Character.digit(s.charAt(i), radix) < 0)) continue;
            return false;
        }
        return true;
    }

    public static <T> T[] mergeArrays(T[] a1, T[] a2) {
        if (a1 != null && a2 != null) {
            Object[] returnArr;
            boolean cloneA1 = a1.length >= a2.length;
            Object[] objectArray = returnArr = cloneA1 ? (Object[])a1.clone() : (Object[])a2.clone();
            if (cloneA1) {
                for (int i = 0; i < a2.length; ++i) {
                    if (a2[i] == null) continue;
                    returnArr[i] = a2[i];
                }
            } else {
                for (int i = 0; i < a1.length; ++i) {
                    if (a1[i] == null) continue;
                    returnArr[i] = a1[i];
                }
            }
            return returnArr;
        }
        if (a1 != null) {
            return (Object[])a1.clone();
        }
        if (a2 != null) {
            return (Object[])a2.clone();
        }
        return null;
    }

    public static String[] mergeStringArrays(String[] a1, String[] a2) {
        if (a1 != null && a2 != null) {
            String[] returnArr;
            boolean cloneA1 = a1.length >= a2.length;
            String[] stringArray = returnArr = cloneA1 ? (String[])a1.clone() : (String[])a2.clone();
            if (cloneA1) {
                for (int i = 0; i < a2.length; ++i) {
                    if (!ObjectUtil.validString(a2[i])) continue;
                    returnArr[i] = a2[i];
                }
            } else {
                for (int i = 0; i < a1.length; ++i) {
                    if (!ObjectUtil.validString(a1[i])) continue;
                    returnArr[i] = a1[i];
                }
            }
            return returnArr;
        }
        if (a1 != null) {
            return (String[])a1.clone();
        }
        if (a2 != null) {
            return (String[])a2.clone();
        }
        return null;
    }

    public static <T> Set<T> toSet(T[] o) {
        return new HashSet<T>(Arrays.asList(o));
    }

    public static String toString(Collection<? extends Object> collection) {
        return Arrays.toString(collection.toArray());
    }

    public static <V, K> Map<V, K> invert(Map<K, V> map) {
        HashMap<V, K> inv = new HashMap<V, K>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            inv.put(entry.getValue(), entry.getKey());
        }
        return inv;
    }

    public static boolean validString(String ... strings) {
        if (strings == null) {
            return false;
        }
        for (String str : strings) {
            if (str == null || str.length() == 0) {
                return false;
            }
            if (str.trim().length() != 0) continue;
            return false;
        }
        return true;
    }

    public static boolean validOneString(String ... strings) {
        if (strings == null) {
            return false;
        }
        for (String str : strings) {
            if (str == null || str.length() <= 0) continue;
            return str.trim().length() != 0;
        }
        return false;
    }

    public static boolean validObject(Object ... objs) {
        if (objs == null) {
            return false;
        }
        for (Object obj : objs) {
            if (obj != null) continue;
            return false;
        }
        return true;
    }

    public static boolean validOneObject(Object ... objs) {
        if (objs == null) {
            return false;
        }
        for (Object obj : objs) {
            if (obj == null) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean equivalentString(String s1, String s2) {
        return ObjectUtil.equivalent(s1, s2);
    }

    public static boolean equivalentArray(Object[] o1, Object[] o2, int ... skipIndexes) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null && o2 != null) {
            return false;
        }
        if (o2 == null && o1 != null) {
            return false;
        }
        if (o1.length != o2.length) {
            return false;
        }
        block0: for (int i = 0; i < o1.length; ++i) {
            if (skipIndexes != null) {
                for (int skip : skipIndexes) {
                    if (skip == i) continue block0;
                }
            }
            if (ObjectUtil.equivalent(o1[i], o2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equivalent(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null && o2 != null) {
            return false;
        }
        if (o2 == null && o1 != null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static boolean equivalentCollection(Collection<?> c1, Collection<?> c2) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c2 == null && c1 != null) {
            return false;
        }
        if (c1 == null && c2 != null) {
            return false;
        }
        if (!ObjectUtil.containsAll(c1, c2)) {
            return false;
        }
        Iterator<?> it1 = c1.iterator();
        Iterator<?> it2 = c2.iterator();
        while (it1.hasNext()) {
            Object obj2;
            Object obj1 = it1.next();
            if (ObjectUtil.equivalent(obj1, obj2 = it2.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean equivalentSet(Set<?> c1, Set<?> c2) {
        return ObjectUtil.containsAll(c1, c2);
    }

    public static boolean equivalentMap(Map<?, ?> c1, Map<?, ?> c2) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c2 == null && c1 != null) {
            return false;
        }
        if (c1 == null && c2 != null) {
            return false;
        }
        if (!ObjectUtil.containsAll(c1.keySet(), c2.keySet())) {
            return false;
        }
        for (Object k : c1.keySet()) {
            if (ObjectUtil.equivalent(c1.get(k), c2.get(k))) continue;
            return false;
        }
        return true;
    }

    public static Map<String, String> trimMap(Map<String, String> map) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        for (String key : map.keySet()) {
            returnMap.put(ObjectUtil.safeTrim(key), ObjectUtil.safeTrim(map.get(key)));
        }
        return returnMap;
    }

    public static String safeTrim(String str) {
        if (str == null) {
            return null;
        }
        return str.trim();
    }

    public static boolean containsAll(Collection<?> c1, Collection<?> c2) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c2 == null && c1 != null) {
            return false;
        }
        if (c1 == null && c2 != null) {
            return false;
        }
        if (c1.size() != c2.size()) {
            return false;
        }
        if (!c1.containsAll(c2)) {
            return false;
        }
        return c2.containsAll(c1);
    }

    public static boolean validCollection(Collection<?> collection) {
        return collection != null && !collection.isEmpty();
    }

    public static boolean isAllNulls(Iterable<?> array) {
        for (Object element : array) {
            if (element == null) continue;
            return false;
        }
        return true;
    }

    public static boolean validArray(Object[] arr) {
        return arr != null && arr.length > 0;
    }

    public static boolean validMap(Map<?, ?> map) {
        return map != null && map.size() > 0;
    }

    public static boolean getBooleanValue(String str) {
        if (str.equalsIgnoreCase("true")) {
            return true;
        }
        if (str.equalsIgnoreCase("false")) {
            return false;
        }
        throw new IllegalArgumentException("Illegal value specified: " + str);
    }

    public static <T> List<T> collectToList(Stream<T> str) {
        return str.collect(Collectors.toList());
    }

    public static <T> Set<T> collectToSet(Stream<T> str) {
        return str.collect(Collectors.toSet());
    }
}

