/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.object;

import io.sdmx.utils.core.object.ObjectUtil;
import java.text.DecimalFormat;

public class NumberUtils {
    private static final char NUM_0 = "0".charAt(0);
    private static final char NUM_1 = "1".charAt(0);
    private static final char NUM_2 = "2".charAt(0);
    private static final char NUM_3 = "3".charAt(0);
    private static final char NUM_4 = "4".charAt(0);
    private static final char NUM_5 = "5".charAt(0);
    private static final char NUM_6 = "6".charAt(0);
    private static final char NUM_7 = "7".charAt(0);
    private static final char NUM_8 = "8".charAt(0);
    private static final char NUM_9 = "9".charAt(0);

    public static boolean startWithNumber(String str) {
        return NumberUtils.isNumber(str.charAt(0));
    }

    public static boolean isInteger(String str) {
        if (str == null | str.length() == 0) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (NumberUtils.isNumber(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean startWithNumber(String str, char upTo) {
        if (str == null) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == upTo) {
                return true;
            }
            if (NumberUtils.isNumber(c)) continue;
            return false;
        }
        return str.length() > 0;
    }

    public static boolean isNumber(char c) {
        if (c == NUM_0) {
            return true;
        }
        if (c == NUM_1) {
            return true;
        }
        if (c == NUM_2) {
            return true;
        }
        if (c == NUM_3) {
            return true;
        }
        if (c == NUM_4) {
            return true;
        }
        if (c == NUM_5) {
            return true;
        }
        if (c == NUM_6) {
            return true;
        }
        if (c == NUM_7) {
            return true;
        }
        if (c == NUM_8) {
            return true;
        }
        return c == NUM_9;
    }

    public static DecimalFormat getDecimalFormat(int maxDecimals) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < maxDecimals; ++i) {
            sb.append("#");
        }
        return new DecimalFormat("." + sb.toString());
    }

    public static String round(DecimalFormat df, String number) {
        if (df != null && number != null) {
            double d;
            try {
                d = Double.parseDouble(number);
            }
            catch (NumberFormatException e) {
                return number;
            }
            if (df.getMaximumFractionDigits() == 0) {
                return number.split("\\.")[0];
            }
            if (Double.isNaN(d)) {
                return number;
            }
            return df.format(d);
        }
        return number;
    }

    public static Double asDouble(String number) {
        if (!NumberUtils.isParsable(number)) {
            return Double.NaN;
        }
        try {
            return Double.parseDouble(number);
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    public static boolean isParsable(String str) {
        if (!ObjectUtil.validString(str)) {
            return false;
        }
        if (str.charAt(str.length() - 1) == '.') {
            return false;
        }
        if (str.charAt(0) == '-') {
            if (str.length() == 1) {
                return false;
            }
            return NumberUtils.withDecimalsParsing(str, 1);
        }
        return NumberUtils.withDecimalsParsing(str, 0);
    }

    private static boolean withDecimalsParsing(String str, int beginIdx) {
        int decimalPoints = 0;
        for (int i = beginIdx; i < str.length(); ++i) {
            boolean isDecimalPoint;
            boolean bl = isDecimalPoint = str.charAt(i) == '.';
            if (isDecimalPoint) {
                ++decimalPoints;
            }
            if (decimalPoints > 1) {
                return false;
            }
            if (isDecimalPoint || Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

