/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.object;

import io.sdmx.utils.core.object.NumberUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class MeasureUtil {
    public static Map<String, BigDecimal> toBigDecimal(Map<String, String> measureValues) {
        HashMap<String, BigDecimal> returnMap = new HashMap<String, BigDecimal>(measureValues.size());
        for (String measureId : measureValues.keySet()) {
            String measureValue = measureValues.get(measureId);
            if (!NumberUtils.isParsable(measureValue)) continue;
            BigDecimal parsed = null;
            try {
                parsed = new BigDecimal(measureValue);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            returnMap.put(measureId, parsed);
        }
        return returnMap;
    }

    public static Map<String, String> toString(Map<String, BigDecimal> numericalMeasures, Map<String, String> measureValues, String replaceMissing) {
        HashMap<String, String> returnMap = new HashMap<String, String>(numericalMeasures.size());
        for (String numericalMeasure : numericalMeasures.keySet()) {
            BigDecimal value = numericalMeasures.get(numericalMeasure);
            String asString = null;
            if (value != null) {
                asString = value.toPlainString();
            } else if (measureValues != null) {
                asString = measureValues.get(numericalMeasure);
            }
            if (value == null) {
                asString = replaceMissing;
            }
            returnMap.put(numericalMeasure, asString);
        }
        if (measureValues != null) {
            for (String measureId : measureValues.keySet()) {
                if (returnMap.containsKey(measureId)) continue;
                returnMap.put(measureId, measureValues.get(measureId));
            }
        }
        return returnMap;
    }
}

