/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.object;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import io.sdmx.utils.core.object.ObjectUtil;
import java.nio.charset.StandardCharsets;

public class HashUtils {
    private static HashFunction fastHasher = Hashing.farmHashFingerprint64();
    private static HashFunction secureHash = Hashing.sha512();

    public static String hashString(String toHash, boolean secure) {
        return ObjectUtil.validString(toHash) ? HashUtils.hashBytes(toHash.getBytes(StandardCharsets.UTF_8), secure).toString() : "";
    }

    public static HashCode hashBytes(byte[] bytes, boolean secure) {
        return secure ? secureHash.hashBytes(bytes) : fastHasher.hashBytes(bytes);
    }
}

