/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.object;

import io.sdmx.utils.core.object.ObjectUtil;
import java.util.Collection;
import java.util.Map;

public class AssertUtil {
    public static void boolMatch(boolean expected, boolean actual, String argName) {
        if (expected != actual) {
            throw new IllegalArgumentException(argName + " is '" + actual + "' expecting '" + expected + "'");
        }
    }

    public static void equivalent(Object obj, Object obj2, String argName) {
        if (!ObjectUtil.equivalent(obj, obj2)) {
            throw new IllegalArgumentException(argName + " are not equal");
        }
    }

    public static void notEmpty(String str, String argName) {
        if (!ObjectUtil.validString(str)) {
            throw new IllegalArgumentException("argument '" + argName + "' is empty or null");
        }
    }

    public static void notNull(Object obj, String argName) {
        if (obj == null) {
            throw new IllegalArgumentException("argument '" + argName + "' is null");
        }
    }

    public static void assertValues(Collection<String> actual, String ... expected) {
        if (expected == null || expected.length == 0) {
            if (actual.size() > 0) {
                throw new RuntimeException("Actual values not expected to contain anything");
            }
        } else {
            for (String currentExpected : expected) {
                if (actual.contains(currentExpected)) continue;
                throw new RuntimeException("Missing expected value: " + currentExpected);
            }
            if (actual.size() != expected.length) {
                throw new RuntimeException("Actual values exceeds expected length");
            }
        }
    }

    public static void assertMap(Map<?, ?> actual, Map<?, ?> expected) {
        for (Object key : actual.keySet()) {
            if (expected.containsKey(key)) continue;
            throw new RuntimeException("Actual values contains key '" + key + "' not in expected map");
        }
        for (Object key : expected.keySet()) {
            if (actual.containsKey(key)) continue;
            throw new RuntimeException("Actual values contains key '" + key + "' not in expected map");
        }
        for (Object key : actual.keySet()) {
            if (expected.get(key).equals(actual.get(key))) continue;
            throw new RuntimeException("Expected value '" + expected + "' differs from Actual value '" + actual + "' for map key '" + key + "'");
        }
    }
}

