/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.notifier;

import io.sdmx.api.notification.Listener;
import io.sdmx.api.notification.Notifier;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNotifier<T>
implements Notifier<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNotifier.class);
    private List<Listener<T>> listners = new ArrayList<Listener<T>>();

    @Override
    public void addListener(Listener<T> listener) {
        if (!this.listners.contains(listener)) {
            this.listners.add(listener);
        }
    }

    @Override
    public void removeListener(Listener<T> listener) {
        this.listners.remove(listener);
    }

    public void notifyListeners(T notification) {
        for (Listener<T> currentLisener : this.listners) {
            try {
                currentLisener.invoke(notification);
            }
            catch (Throwable th) {
                th.printStackTrace();
                LOG.error(th.getMessage());
            }
        }
    }
}

