/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.io;

import io.sdmx.api.exception.ExceptionCode;
import io.sdmx.api.exception.SdmxException;
import io.sdmx.api.exception.SdmxSemmanticException;
import io.sdmx.api.exception.SdmxServiceUnavailableException;
import io.sdmx.api.exception.SdmxUnauthorisedException;
import io.sdmx.utils.core.object.ObjectUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLUtil {
    private static final Logger LOG = LoggerFactory.getLogger(URLUtil.class);
    private static int CONNECT_TIMEOUT = 120000;
    private static int RESPONSE_TIMEOUT = 120000;
    private static String userAgent;

    private static TrustManager[] getTrustAllCerts() {
        return new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
            }
        }};
    }

    public static InputStream getInputStream(URL url) {
        LOG.debug("Get Input Stream from URL: " + url);
        URLConnection connection = URLUtil.getconnection(url);
        return URLUtil.getInputStream(connection, null);
    }

    private static URLConnection getconnection(URL url) {
        URLConnection urlc;
        LOG.debug("Get URLConnection: " + url);
        try {
            urlc = url.openConnection();
        }
        catch (IOException e) {
            throw new SdmxServiceUnavailableException((Throwable)e, ExceptionCode.WEB_SERVICE_BAD_CONNECTION, url.toString());
        }
        urlc.setDoOutput(true);
        urlc.setAllowUserInteraction(false);
        urlc.addRequestProperty("Accept-Encoding", "gzip");
        urlc.addRequestProperty("Accept", "*/*;q=1.0");
        if (ObjectUtil.validString(userAgent)) {
            urlc.setRequestProperty("User-Agent", userAgent);
        }
        urlc.setConnectTimeout(CONNECT_TIMEOUT);
        urlc.setReadTimeout(RESPONSE_TIMEOUT);
        if (urlc instanceof HttpURLConnection) {
            HttpURLConnection httpConn = (HttpURLConnection)urlc;
            httpConn.setInstanceFollowRedirects(true);
        } else if (urlc instanceof HttpsURLConnection) {
            HttpsURLConnection httpConn = (HttpsURLConnection)urlc;
            httpConn.setInstanceFollowRedirects(true);
        }
        return urlc;
    }

    public static Map<String, Long> pingHosts(String servers, int timeout) {
        String[] hostPortPairs;
        HashMap<String, Long> returnMap = new HashMap<String, Long>();
        for (String hostPortPair : hostPortPairs = servers.split(",")) {
            Integer portInt;
            String[] elements = hostPortPair.split(":");
            if (elements.length != 2) {
                throw new SdmxSemmanticException("Illegal server format for string '" + hostPortPair + "'. expecting format 'server:port'");
            }
            String host = elements[0].trim();
            String port = elements[1].trim();
            try {
                portInt = Integer.parseInt(port);
            }
            catch (NumberFormatException e) {
                throw new SdmxSemmanticException("Illegal server format for string '" + hostPortPair + "'. expecting format 'server:port' where port is a valid Integer");
            }
            long timeNow = System.currentTimeMillis();
            if (URLUtil.pingHost(host, portInt, timeout)) {
                long timeComplete = System.currentTimeMillis();
                returnMap.put(hostPortPair, timeComplete - timeNow);
                continue;
            }
            returnMap.put(hostPortPair, -1L);
        }
        return returnMap;
    }

    public static boolean pingHost(String host, int port, int timeout) {
        boolean bl;
        Socket socket = new Socket();
        try {
            if (timeout == -1) {
                socket.connect(new InetSocketAddress(host, port));
            } else {
                socket.connect(new InetSocketAddress(host, port), timeout);
            }
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        socket.close();
        return bl;
    }

    public static String appendQueryParameters(String url, Map<String, String> parameters) {
        if (parameters == null || parameters.size() == 0) {
            return url;
        }
        StringBuilder sb = new StringBuilder(url);
        String concat = url.contains("?") ? "&" : "?";
        for (String param : parameters.keySet()) {
            sb.append(concat + param + "=" + parameters.get(param));
            concat = "&";
        }
        return sb.toString();
    }

    private static InputStream getInputStream(URLConnection urlc, Object payload) {
        InputStream stream;
        try {
            if (payload != null) {
                PrintStream ps = new PrintStream(urlc.getOutputStream());
                ps.print(payload);
                ps.close();
            }
            stream = URLUtil.getInputStream(urlc);
        }
        catch (IOException e) {
            throw new SdmxServiceUnavailableException((Throwable)e, ExceptionCode.WEB_SERVICE_BAD_CONNECTION, e.getMessage());
        }
        if (urlc.getContentEncoding() != null && urlc.getContentEncoding().equals("gzip")) {
            LOG.debug("Response received as GZIP");
            try {
                stream = new GZIPInputStream(stream);
            }
            catch (IOException e) {
                throw new SdmxException(e, "I/O Ecception while trying to unzip stream retrieved from service:" + urlc.getURL());
            }
        }
        return stream;
    }

    private static InputStream getInputStream(URLConnection urlc) {
        try {
            return urlc.getInputStream();
        }
        catch (ConnectException c) {
            LOG.error("ConnectException:" + c.getMessage());
            throw new SdmxServiceUnavailableException((Throwable)c, ExceptionCode.WEB_SERVICE_BAD_CONNECTION, urlc.getURL());
        }
        catch (SocketException c) {
            LOG.error("SocketException:" + c.getMessage());
            throw new SdmxServiceUnavailableException((Throwable)c, ExceptionCode.WEB_SERVICE_BAD_CONNECTION, urlc.getURL());
        }
        catch (SocketTimeoutException c) {
            LOG.error("SocketTimeoutException:" + c.getMessage());
            throw new SdmxServiceUnavailableException((Throwable)c, ExceptionCode.WEB_SERVICE_SOCKET_TIMEOUT, urlc.getReadTimeout());
        }
        catch (IOException e) {
            if (urlc instanceof HttpURLConnection) {
                try {
                    if (((HttpURLConnection)urlc).getResponseCode() == 401) {
                        throw new SdmxUnauthorisedException(e.getMessage());
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                HttpURLConnection httpConnection = (HttpURLConnection)urlc;
                InputStream is = httpConnection.getErrorStream();
                if (is != null) {
                    return is;
                }
            }
            String message = null;
            if (e.getMessage().contains("Server returned HTTP response code:")) {
                String split = e.getMessage().split(":")[1];
                split = split.trim();
                split = split.substring(0, split.indexOf(" "));
                try {
                    int responseCode = Integer.parseInt(split);
                    switch (responseCode) {
                        case 400: {
                            message = "Response Code 400 = The request could not be understood by the server due to malformed syntax";
                            break;
                        }
                        case 401: {
                            message = "Response Code 401 = Authentication failure";
                            break;
                        }
                        case 403: {
                            message = "Response Code 403 = The server understood the request, but is refusing to fulfill it";
                            break;
                        }
                        case 404: {
                            message = "Response Code 404 = Page not found";
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (message != null) {
                throw new SdmxServiceUnavailableException((Throwable)e, ExceptionCode.WEB_SERVICE_BAD_CONNECTION, message);
            }
            throw new SdmxServiceUnavailableException((Throwable)e, ExceptionCode.WEB_SERVICE_BAD_CONNECTION, urlc.getURL());
        }
    }

    public static URL getURL(String urlStr) {
        try {
            return new URL(urlStr);
        }
        catch (MalformedURLException e) {
            throw new SdmxException("Malformed URL: " + urlStr);
        }
    }

    private static void verifyURL(URL url, boolean followRedirects) throws IllegalArgumentException {
        if (!URLUtil.urlExists(url)) {
            throw new IllegalArgumentException("URL could not be resolved: " + url.toString());
        }
        int responseCode = URLUtil.getResponseCode(url);
        if (responseCode == 0) {
            return;
        }
        String responseCodeStr = Integer.toString(responseCode);
        if (responseCodeStr.startsWith("1") || responseCodeStr.startsWith("2")) {
            return;
        }
        if (responseCodeStr.startsWith("3") && !followRedirects) {
            throw new IllegalArgumentException("URL '" + url.toString() + "' returns an HTTP '" + responseCodeStr + "' response code (Redirect). Redirections are not supported");
        }
        if (responseCodeStr.startsWith("401")) {
            throw new IllegalArgumentException("URL '" + url.toString() + "' returns an HTTP Redirect 401 response code (Unauthorised)");
        }
        if (responseCodeStr.startsWith("402")) {
            throw new IllegalArgumentException("URL '" + url.toString() + "' returns an HTTP Redirect 402 response code (Payment Required)");
        }
        if (responseCodeStr.startsWith("407")) {
            throw new IllegalArgumentException("URL '" + url.toString() + "' returns an HTTP Redirect 407 response code (Proxy Authentication Required)");
        }
    }

    public static boolean urlExists(URL url) {
        try {
            int responseCode = URLUtil.getResponseCode(url);
            String responseCodeStr = Integer.toString(responseCode);
            if (responseCodeStr.startsWith("0") || responseCodeStr.startsWith("1") || responseCodeStr.startsWith("2") || responseCodeStr.startsWith("3") || responseCodeStr.equals("401") || responseCodeStr.equals("402") || responseCodeStr.equals("405") || responseCodeStr.equals("406") || responseCodeStr.equals("407")) {
                return true;
            }
            LOG.warn("URL " + url + " returns status code: " + responseCodeStr);
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static int getResponseCode(URL url) {
        try {
            HttpURLConnection.setFollowRedirects(false);
            URLConnection con = url.openConnection();
            if (con instanceof HttpsURLConnection) {
                HttpsURLConnection httpsCon = (HttpsURLConnection)con;
                HostnameVerifier hv = (arg0, arg1) -> true;
                httpsCon.setHostnameVerifier(hv);
            }
            if (con instanceof HttpURLConnection) {
                HttpURLConnection httpCon = (HttpURLConnection)con;
                httpCon.setRequestMethod("HEAD");
                return httpCon.getResponseCode();
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static boolean isUrlEncoded(String url, String charSet) throws UnsupportedEncodingException {
        return !url.equals(URLDecoder.decode(url, charSet));
    }

    public static String enforceHttpProtocol(String url) {
        if (!ObjectUtil.validString(url)) {
            return url;
        }
        if (!(url = url.trim()).startsWith("http") && !url.startsWith("https")) {
            url = "http://" + url;
        }
        return url;
    }

    public static String sanitiseSlashesInUrl(String url) {
        while (url.length() > 0 && url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        url = url.replaceAll("(?<!(http:|https:))[//]+", "/");
        return url;
    }

    public static void setUserAgent(String val) {
        userAgent = val;
    }

    public static void setResponseTimeout(int responseTimeout) {
        RESPONSE_TIMEOUT = responseTimeout * 1000;
    }

    public static void setConnectTimeout(int responseTimeout) {
        CONNECT_TIMEOUT = responseTimeout * 1000;
    }

    static {
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, URLUtil.getTrustAllCerts(), new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier((hostname, ssls) -> true);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

