/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.io;

import io.sdmx.utils.core.io.FileUtil;
import io.sdmx.utils.core.io.StreamUtil;
import io.sdmx.utils.core.io.URLUtil;
import io.sdmx.utils.core.logging.LoggingUtil;
import io.sdmx.utils.core.object.ObjectUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class URIUtil {
    private static final Logger LOG = LoggerFactory.getLogger(URIUtil.class);
    private static URIUtil TEMPORARY_URI_UTIL = new URIUtil("resources/streams/tmp", "tmpFile", 1440000L, true);
    private static Set<String> uris = Collections.synchronizedSet(new HashSet());
    private static Map<URI, List<OutputStream>> outputstreamMap = new HashMap<URI, List<OutputStream>>();
    private static Map<URI, List<InputStream>> inputstreamMap = new HashMap<URI, List<InputStream>>();
    private String fileBaseName = "tmp_file.";

    public static String formatStringForURI(String input) {
        return input.replaceAll(" ", "%20").replaceAll("\\\\", "/");
    }

    public static URIUtil getURIUtil() {
        return TEMPORARY_URI_UTIL;
    }

    public static URI getTemporaryURI() {
        URI uri = TEMPORARY_URI_UTIL.getUri();
        return uri;
    }

    public static URIUtil getURIUtil(String directoryName, String fileBaseName, boolean overwrite) {
        return new URIUtil(directoryName, fileBaseName, 0L, overwrite);
    }

    private URIUtil(String uriDirectory, String fileBaseName, long deleteFilesOlderThen, boolean overwright) {
        this.fileBaseName = fileBaseName;
    }

    public static void closeUri(URI uri) {
        if (uri != null) {
            uris.remove(uri.toString());
        }
    }

    public static String getFullPath(URI uri) {
        File file = new File(uri.getPath());
        return file.getAbsolutePath();
    }

    public static boolean deleteUri(URI uri) {
        if (uri == null) {
            return false;
        }
        URIUtil.closeStreams(uri);
        File file = new File(uri.getPath());
        boolean deleted = file.delete();
        URIUtil.closeUri(uri);
        return deleted;
    }

    public static void closeStreams(URI uri) {
        if (outputstreamMap.containsKey(uri)) {
            for (OutputStream out : outputstreamMap.get(uri)) {
                StreamUtil.closeStream(out);
            }
        }
        if (inputstreamMap.containsKey(uri)) {
            for (InputStream in : inputstreamMap.get(uri)) {
                StreamUtil.closeStream(in);
            }
        }
        outputstreamMap.remove(uri);
        inputstreamMap.remove(uri);
    }

    public static void copyURIs(URI uriIn, URI uriOut) {
        try (FileInputStream fis = new FileInputStream(uriIn.getPath());
             FileOutputStream fos = new FileOutputStream(uriOut.getPath());){
            StreamUtil.copyStream(fis, fos, true);
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
    }

    public static InputStream getInputStream(URI uri) {
        InputStream stream;
        try {
            URL url = uri.toURL();
            stream = URLUtil.getInputStream(url);
        }
        catch (Throwable th) {
            String filePath = ObjectUtil.validString(uri.getPath()) ? uri.getPath() : uri.getSchemeSpecificPart();
            try {
                stream = new BufferedInputStream(new FileInputStream(filePath));
            }
            catch (FileNotFoundException e) {
                ClassPathResource mr = new ClassPathResource(filePath);
                try {
                    stream = mr.getInputStream();
                }
                catch (IOException e1) {
                    throw new RuntimeException("Could not load resource: " + filePath);
                }
            }
        }
        URIUtil.storeStream(uri, stream);
        return stream;
    }

    private static void storeStream(URI uri, InputStream stream) {
        List<Object> streams = null;
        if (inputstreamMap.containsKey(uri)) {
            streams = inputstreamMap.get(uri);
        } else {
            streams = new ArrayList();
            inputstreamMap.put(uri, streams);
        }
        streams.add(stream);
    }

    public static OutputStream getOutputStream(URI uri) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(uri.getPath(), true);
            BufferedOutputStream out = new BufferedOutputStream(fos);
            List<Object> streams = null;
            if (outputstreamMap.containsKey(uri)) {
                streams = outputstreamMap.get(uri);
            } else {
                streams = new ArrayList();
                outputstreamMap.put(uri, streams);
            }
            streams.add(out);
            return out;
        }
        catch (Exception e) {
            if (fos != null) {
                StreamUtil.closeStream(fos);
            }
            throw new RuntimeException(e);
        }
    }

    public synchronized URI getUri() {
        try {
            File f = FileUtil.createTemporaryFile(this.fileBaseName, "sdmxsource_tmp");
            URI uri = f.toURI();
            if (!uris.contains(uri.toString())) {
                uris.add(uri.toString());
            }
            if (LOG.isDebugEnabled()) {
                Throwable t = new Throwable();
                StackTraceElement[] elements = t.getStackTrace();
                String callerMethodName = null;
                String callerClassName = null;
                for (int x = 0; x < elements.length; ++x) {
                    callerMethodName = elements[x].getMethodName();
                    callerClassName = elements[x].getClassName();
                    if (!callerClassName.equals(URIUtil.class.getName())) break;
                }
                LoggingUtil.debug(LOG, "getTemporaryURI request from (class.method)" + callerClassName + "." + callerMethodName);
                LoggingUtil.debug(LOG, "URI created " + uri.getPath());
            }
            return uri;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] getByteArray(URI uri) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        StreamUtil.copyStream(URIUtil.getInputStream(uri), bos);
        return bos.toByteArray();
    }

    public URI getUri(byte[] bytes) {
        URI uri = this.getUri();
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(uri.getPath()));){
            bos.write(bytes, 0, bytes.length);
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
        return uri;
    }

    public URI getUri(InputStream stream) {
        URI uri = this.getUri();
        try {
            StreamUtil.copyStream(stream, new BufferedOutputStream(new FileOutputStream(uri.getPath())), true);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        return uri;
    }

    public static File getFile(URI uri) {
        return new File(uri.getPath());
    }
}

