/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamUtil {
    private static final Logger LOG = LoggerFactory.getLogger(StreamUtil.class);

    public static PrintWriter getPrintWriterUTF8(OutputStream out) {
        return StreamUtil.getPrintWriterUTF8(out, true);
    }

    public static PrintWriter getPrintWriterUTF8(OutputStream out, boolean outputBOM) {
        PrintWriter pwOut = new PrintWriter((Writer)new OutputStreamWriter(out, StandardCharsets.UTF_8), true);
        if (outputBOM) {
            pwOut.write(65279);
        }
        return pwOut;
    }

    public static InputStream asStream(List<byte[]> bytesList) {
        return new ByteArrayInputStream(StreamUtil.joinBytes(bytesList));
    }

    public static byte[] joinBytes(List<byte[]> bytesList) {
        int length = 0;
        for (byte[] currentArray : bytesList) {
            length += currentArray.length;
        }
        byte[] merged = new byte[length];
        length = 0;
        for (byte[] currentArray : bytesList) {
            System.arraycopy(currentArray, 0, merged, length, currentArray.length);
            length += currentArray.length;
        }
        return merged;
    }

    public static void splitBytes(List<byte[]> list, byte[] bytes, int chunkLength, int offset) {
        byte[] dest;
        int lengthTocopy;
        while (bytes.length - offset > chunkLength) {
            lengthTocopy = bytes.length - offset > chunkLength ? chunkLength : bytes.length - offset;
            dest = new byte[lengthTocopy];
            System.arraycopy(bytes, offset, dest, 0, lengthTocopy);
            list.add(dest);
            offset += lengthTocopy;
        }
        lengthTocopy = bytes.length - offset;
        if (lengthTocopy > 0) {
            dest = new byte[lengthTocopy];
            System.arraycopy(bytes, offset, dest, 0, lengthTocopy);
            list.add(dest);
        }
    }

    private static void copyNonUTF8InputStream(InputStream is, OutputStream os) {
        try (BufferedInputStream bis = new BufferedInputStream(is);
             OutputStreamWriter bos = new OutputStreamWriter((OutputStream)new BufferedOutputStream(os), "UTF-8");){
            int i;
            byte[] bytes = new byte[1024];
            while ((i = bis.read(bytes)) > 0) {
                bos.write(new String(bytes, 0, i));
            }
            ((Writer)bos).flush();
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
    }

    public static List<String> copyFirstXLines(InputStream stream, int numLines) {
        ArrayList<String> firstXRows = new ArrayList<String>();
        if (stream == null) {
            return firstXRows;
        }
        int rowCount = 0;
        boolean lastCharWasEndOfLine = false;
        StringBuffer buff = new StringBuffer();
        byte[] bytes = new byte[1024];
        boolean keepProcessing = true;
        try {
            int i;
            block2: while ((i = stream.read(bytes)) > 0 && keepProcessing) {
                for (int j = 0; j < i; ++j) {
                    byte aByte = bytes[j];
                    if (aByte == 10 || aByte == 13) {
                        if (!lastCharWasEndOfLine) {
                            lastCharWasEndOfLine = true;
                            ++rowCount;
                            firstXRows.add(buff.toString());
                            buff = new StringBuffer();
                        }
                    } else {
                        lastCharWasEndOfLine = false;
                        buff.append((char)aByte);
                    }
                    if (rowCount != numLines) continue;
                    keepProcessing = false;
                    continue block2;
                }
            }
            if (rowCount < numLines) {
                firstXRows.add(buff.toString());
            }
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
        return firstXRows;
    }

    public static byte[] readFirstXBytes(InputStream stream, int numberOfBytes) {
        byte[] b = new byte[numberOfBytes];
        try {
            int numberRead = stream.read(b);
            if (numberRead < numberOfBytes) {
                byte[] returnArray = new byte[numberRead];
                for (int i = 0; i < numberRead; ++i) {
                    returnArray[i] = b[i];
                }
                return returnArray;
            }
        }
        catch (IOException | NegativeArraySizeException e) {
            throw new RuntimeException("Error reading stream");
        }
        return b;
    }

    public static int copyStream(InputStream is, OutputStream os) {
        return StreamUtil.copyUTF8InputStream(is, os, false);
    }

    public static int copyStream(InputStream is, OutputStream os, boolean closeOuptutStream) {
        return StreamUtil.copyUTF8InputStream(is, os, closeOuptutStream);
    }

    private static int copyUTF8InputStream(InputStream is, OutputStream os, boolean closeOutputStream) {
        int n;
        LOG.debug("Copy Input Stream:" + is + " to output stream:" + os + ", close output stream on completion=" + closeOutputStream);
        BufferedOutputStream bos = null;
        BufferedInputStream bis = null;
        try {
            int i;
            bis = is instanceof BufferedInputStream ? (BufferedInputStream)is : new BufferedInputStream(is);
            bos = os instanceof BufferedOutputStream ? (BufferedOutputStream)os : new BufferedOutputStream(os);
            byte[] bytes = new byte[1024];
            int bytesRead = 0;
            while ((i = bis.read(bytes)) > 0) {
                bytesRead += i;
                bos.write(bytes, 0, i);
            }
            bos.flush();
            n = bytesRead;
        }
        catch (Throwable th) {
            try {
                th.printStackTrace();
                throw new RuntimeException(th);
            }
            catch (Throwable throwable) {
                StreamUtil.closeStream(bis);
                if (bos != null) {
                    try {
                        bos.flush();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (os != null) {
                    try {
                        os.flush();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (closeOutputStream) {
                    StreamUtil.closeStream(bos);
                }
                throw throwable;
            }
        }
        StreamUtil.closeStream(bis);
        if (bos != null) {
            try {
                bos.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (os != null) {
            try {
                os.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (closeOutputStream) {
            StreamUtil.closeStream(bos);
        }
        return n;
    }

    public static void copyUTF8InputStream(InputStream is, OutputStream os, int ignoreEndBytesCount, boolean closeOutputStream) {
        LOG.debug("Copy Input Stream:" + is + " to output stream:" + os + ", close output stream on completion=" + closeOutputStream);
        BufferedOutputStream bos = null;
        BufferedInputStream bis = null;
        try {
            int i;
            bis = is instanceof BufferedInputStream ? (BufferedInputStream)is : new BufferedInputStream(is);
            bos = os instanceof BufferedOutputStream ? (BufferedOutputStream)os : new BufferedOutputStream(os);
            byte[] bytes = new byte[1024];
            byte[] bytes2 = new byte[1024];
            while ((i = bis.read(bytes)) > 0) {
                int i2 = bis.read(bytes2);
                if (i2 < 1024 || bytes2[i - 1] == -1) {
                    if (i2 < ignoreEndBytesCount) {
                        int copy1 = i2 < 0 ? ignoreEndBytesCount : ignoreEndBytesCount - i2;
                        bos.write(bytes, 0, i - copy1);
                    } else {
                        bos.write(bytes, 0, i);
                        bos.write(bytes2, 0, i2 -= ignoreEndBytesCount);
                    }
                } else {
                    bos.write(bytes, 0, i);
                }
                i = i2;
            }
            bos.flush();
        }
        catch (Throwable th) {
            try {
                th.printStackTrace();
                throw new RuntimeException(th);
            }
            catch (Throwable throwable) {
                StreamUtil.closeStream(bis);
                if (bos != null) {
                    try {
                        bos.flush();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (os != null) {
                    try {
                        os.flush();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (closeOutputStream) {
                    StreamUtil.closeStream(bos);
                }
                throw throwable;
            }
        }
        StreamUtil.closeStream(bis);
        if (bos != null) {
            try {
                bos.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (os != null) {
            try {
                os.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (closeOutputStream) {
            StreamUtil.closeStream(bos);
        }
    }

    /*
     * Exception decompiling
     */
    public static byte[] toByteArray(InputStream is) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFirstXBytes(InputStream is, int lengthToObtain) {
        try {
            int n;
            byte[] b = new byte[lengthToObtain];
            for (int count = 0; count < b.length && (n = is.read(b, count, b.length - count)) != -1; count += n) {
            }
            String string = new String(b);
            return string;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            try {
                is.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public static void writeOutput(JSONArray str, OutputStream out) {
        StreamUtil.writeOutput(str.toString(), out);
    }

    public static void writeOutput(JSONObject str, OutputStream out) {
        StreamUtil.writeOutput(str.toString(), out);
    }

    public static void writeOutput(String str, OutputStream out) {
        StreamUtil.writeOutput(str.getBytes(), out);
    }

    public static void writeOutput(byte[] b, OutputStream out) {
        try {
            out.write(b);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing to stream", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFirstXBytesUpToCRLF(InputStream is, int lengthToObtain) {
        try {
            int n;
            byte[] byteArray = new byte[lengthToObtain];
            for (int count = 0; count < byteArray.length && (n = is.read(byteArray, count, byteArray.length - count)) != -1; count += n) {
            }
            int stopPosition = 0;
            for (byte aByte : byteArray) {
                if (aByte == 0 || aByte == 10 || aByte == 13) break;
                ++stopPosition;
            }
            if (stopPosition == lengthToObtain) {
                String string = new String(byteArray);
                return string;
            }
            String string = new String(byteArray, 0, stopPosition);
            return string;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            try {
                is.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public static void closeStream(OutputStream ... out) {
        if (out == null) {
            return;
        }
        for (OutputStream currentOut : out) {
            try {
                if (currentOut == null) continue;
                currentOut.close();
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
    }

    public static void closeStream(InputStream ... in) {
        if (in == null) {
            return;
        }
        for (InputStream currentIn : in) {
            if (currentIn == null) continue;
            try {
                currentIn.close();
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
    }
}

