/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.io;

import io.sdmx.utils.core.io.FileUtil;
import io.sdmx.utils.core.io.SingletonOIS;
import io.sdmx.utils.core.io.StreamUtil;
import io.sdmx.utils.core.io.URIUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class SerializeUtil {
    public static <T extends Serializable> List<byte[]> serializeAsChunkedByteArray(T serializable, int chunkLength, boolean compress) {
        ByteArrayOutputStream serialized = SerializeUtil.serializeAsByteArray(serializable, compress);
        ArrayList<byte[]> byteList = new ArrayList<byte[]>();
        SerializeUtil.splitBytes(byteList, serialized.toByteArray(), chunkLength, 0);
        return byteList;
    }

    private static void splitBytes(List<byte[]> list, byte[] bytes, int chunkLength, int offset) {
        int lengthTocopy = bytes.length - offset > chunkLength ? chunkLength : bytes.length - offset;
        byte[] dest = new byte[lengthTocopy];
        System.arraycopy(bytes, offset, dest, 0, lengthTocopy);
        list.add(dest);
        if (bytes.length - offset > chunkLength) {
            SerializeUtil.splitBytes(list, bytes, chunkLength, offset + lengthTocopy);
        }
    }

    public static <T extends Serializable> T deSerializeChunkedByteArray(List<byte[]> buffer) {
        int length = 0;
        for (byte[] byArray : buffer) {
            length += byArray.length;
        }
        byte[] merged = new byte[length];
        length = 0;
        for (byte[] currentArray3 : buffer) {
            System.arraycopy(currentArray3, 0, merged, length, currentArray3.length);
            length += currentArray3.length;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(merged);
        return SerializeUtil.deSerialize(byteArrayInputStream, false);
    }

    public static <T extends Serializable> void serializeToOutputStream(T serializable, OutputStream output) {
        ObjectOutputStream obj_out = null;
        try {
            obj_out = new ObjectOutputStream(output);
            obj_out.writeObject(serializable);
        }
        catch (Throwable th) {
            try {
                throw new RuntimeException(th);
            }
            catch (Throwable throwable) {
                StreamUtil.closeStream(output);
                StreamUtil.closeStream(obj_out);
                throw throwable;
            }
        }
        StreamUtil.closeStream(output);
        StreamUtil.closeStream(obj_out);
    }

    public static <T extends Serializable> ByteArrayOutputStream serializeAsByteArray(T serializable, boolean compress) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        if (compress) {
            GZIPOutputStream zipOut;
            try {
                zipOut = new GZIPOutputStream(output);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            SerializeUtil.serializeToOutputStream(serializable, zipOut);
        } else {
            SerializeUtil.serializeToOutputStream(serializable, output);
        }
        return output;
    }

    public static <T extends Serializable> void serialize(URI filelocation, T serializable) {
        File f = URIUtil.getFile(filelocation);
        SerializeUtil.serialize(f, serializable);
    }

    public static <T extends Serializable> void serialize(String fileName, T serializable) {
        SerializeUtil.serialize(new File(fileName), serializable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Serializable> void serialize(File f, T Serializable2) {
        FileOutputStream f_out = null;
        ObjectOutputStream obj_out = null;
        try {
            if (f.exists()) {
                f.delete();
            }
            f.createNewFile();
            f_out = new FileOutputStream(f);
            obj_out = new ObjectOutputStream(f_out);
            obj_out.writeObject(Serializable2);
        }
        catch (Throwable th) {
            try {
                System.out.println(th);
            }
            catch (Throwable throwable) {
                StreamUtil.closeStream(f_out);
                StreamUtil.closeStream(obj_out);
                throw throwable;
            }
            StreamUtil.closeStream(f_out);
            StreamUtil.closeStream(obj_out);
        }
        StreamUtil.closeStream(f_out);
        StreamUtil.closeStream(obj_out);
    }

    public static <T extends Serializable> T deSerialize(InputStream inputStream, boolean unzip) {
        Serializable serializable;
        SingletonOIS obj_in = null;
        try {
            if (unzip) {
                inputStream = new GZIPInputStream(inputStream);
            }
            obj_in = new SingletonOIS(inputStream);
            Object obj = obj_in.readObject();
            serializable = (Serializable)obj;
        }
        catch (Throwable th) {
            try {
                throw new RuntimeException("Could not deserialize from stream", th);
            }
            catch (Throwable throwable) {
                StreamUtil.closeStream(inputStream);
                StreamUtil.closeStream(obj_in);
                throw throwable;
            }
        }
        StreamUtil.closeStream(inputStream);
        StreamUtil.closeStream(obj_in);
        return (T)serializable;
    }

    public static <T extends Serializable> T deSerialize(String filePath) {
        Serializable serializable;
        FileInputStream f_in = null;
        ObjectInputStream obj_in = null;
        if (!FileUtil.exists(filePath)) {
            return null;
        }
        try {
            f_in = new FileInputStream(filePath);
            obj_in = new ObjectInputStream(f_in);
            Object obj = obj_in.readObject();
            serializable = (Serializable)obj;
        }
        catch (Throwable th) {
            try {
                throw new RuntimeException("Could not deserialize from file: " + filePath, th);
            }
            catch (Throwable throwable) {
                StreamUtil.closeStream(f_in);
                StreamUtil.closeStream(obj_in);
                throw throwable;
            }
        }
        StreamUtil.closeStream(f_in);
        StreamUtil.closeStream(obj_in);
        return (T)serializable;
    }
}

