/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.io;

import io.sdmx.api.format.FILE_FORMAT;
import io.sdmx.api.io.ReadableDataLocation;
import io.sdmx.api.io.ReadableDataLocationFactory;
import io.sdmx.utils.core.file.FormatUtil;
import io.sdmx.utils.core.io.FileUtil;
import io.sdmx.utils.core.io.StreamUtil;
import io.sdmx.utils.core.io.URIUtil;
import io.sdmx.utils.core.io.URLUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdmxSourceReadableDataLocationFactory
implements ReadableDataLocationFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SdmxSourceReadableDataLocationFactory.class);
    private Long maxMemory = 0x1E00000L;
    private Long memoryUseage = 0L;

    @Override
    public ReadableDataLocation getReadableDataLocation(String uriStr) {
        if (uriStr == null) {
            throw new IllegalArgumentException("Can not create StreamSourceData - uriStr can not be null");
        }
        try {
            URI uri = new URI(uriStr);
            if (uri.isAbsolute()) {
                if (!uri.getScheme().equals("file")) {
                    URL url = uri.toURL();
                    InputStream is = URLUtil.getInputStream(url);
                    return this.getReadableDataLocation(is);
                }
                File f = URIUtil.getFile(uri);
                if (!f.exists()) {
                    throw new IllegalArgumentException("Can not read stream, file does not exist: " + uriStr);
                }
            }
            return new OverflowReadableDataLocation(uri, false);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ReadableDataLocation getReadableDataLocation(byte[] bytes) {
        return new OverflowReadableDataLocation(bytes);
    }

    @Override
    public ReadableDataLocation getReadableDataLocation(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Can not create StreamSourceData - file can not be null");
        }
        if (FileUtil.getFileSize(file) > this.maxMemory - this.memoryUseage) {
            return new OverflowReadableDataLocation(file.toURI(), false);
        }
        try {
            return this.getReadableDataLocation(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ReadableDataLocation getReadableDataLocation(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("Can not create StreamSourceData - url can not be null");
        }
        InputStream is = URLUtil.getInputStream(url);
        return this.getReadableDataLocation(is);
    }

    @Override
    public ReadableDataLocation getReadableDataLocation(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Can not create StreamSourceData - uri can not be null");
        }
        return this.getReadableDataLocation(URIUtil.getInputStream(uri));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReadableDataLocation getReadableDataLocation(InputStream is) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(out);
        boolean completedRead = false;
        if (this.memoryUseage < this.maxMemory) {
            completedRead = true;
            try {
                int i;
                byte[] bytes = new byte[1024];
                while ((i = is.read(bytes)) > 0) {
                    bos.write(bytes, 0, i);
                    this.memoryUseage = this.memoryUseage + (long)i;
                    if (this.memoryUseage <= this.maxMemory) continue;
                    completedRead = false;
                    break;
                }
                bos.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        if (completedRead) {
            StreamUtil.closeStream(is);
            return new OverflowReadableDataLocation(out.toByteArray());
        }
        LOG.info("Limit hit on getting ReadableDataLocation, overflow to tmp URI");
        URI uri = URIUtil.getTemporaryURI();
        LOG.debug("URI: " + uri.toString());
        OutputStream tmpOut = URIUtil.getOutputStream(uri);
        bos = new BufferedOutputStream(tmpOut);
        if (out.size() > 0) {
            StreamUtil.copyStream(new ByteArrayInputStream(out.toByteArray()), bos, false);
            this.memoryUseage = this.memoryUseage - (long)out.size();
            out = null;
        }
        try {
            StreamUtil.copyStream(is, bos, false);
        }
        catch (Throwable throwable) {
            StreamUtil.closeStream(is);
            StreamUtil.closeStream(bos);
            throw throwable;
        }
        StreamUtil.closeStream(is);
        StreamUtil.closeStream(bos);
        return new OverflowReadableDataLocation(uri, true);
    }

    public Long getMemoryUseageBytes() {
        return this.memoryUseage;
    }

    public void setMaxMemoryKb(int maxMemory) {
        this.maxMemory = Long.valueOf(maxMemory) * 1024L;
    }

    class OverflowReadableDataLocation
    implements ReadableDataLocation {
        private static final long serialVersionUID = -8299140445772552916L;
        private byte[] bytes;
        private URI uri;
        private boolean deleteOnClose;
        private boolean isClosed = false;
        private boolean isProtected = false;
        private FILE_FORMAT format;

        private OverflowReadableDataLocation(byte[] bytes) {
            this.bytes = bytes;
        }

        private OverflowReadableDataLocation(URI uri, boolean deleteOnClose) {
            this.uri = uri;
            this.deleteOnClose = deleteOnClose;
        }

        @Override
        public InputStream getInputStream() {
            if (this.isClosed) {
                throw new RuntimeException("Can not obtain InputStream from SdmxSourceReadableDataLocationFactory since it has been closed.");
            }
            if (this.bytes != null) {
                return new BufferedInputStream(new ByteArrayInputStream(this.bytes));
            }
            return URIUtil.getInputStream(this.uri);
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public FILE_FORMAT getFormat() {
            if (this.format == null) {
                this.format = FormatUtil.determineFileFormat(this);
            }
            return this.format;
        }

        @Override
        public void close() {
            if (this.isClosed || this.isProtected) {
                return;
            }
            this.isClosed = true;
            if (this.bytes != null) {
                SdmxSourceReadableDataLocationFactory.this.memoryUseage = SdmxSourceReadableDataLocationFactory.this.memoryUseage - (long)this.bytes.length;
                this.bytes = null;
            } else if (this.uri != null) {
                URIUtil.closeUri(this.uri);
                if (this.deleteOnClose) {
                    URIUtil.deleteUri(this.uri);
                }
            }
        }

        @Override
        public boolean isClosed() {
            return this.isClosed;
        }

        @Override
        public OverflowReadableDataLocation copy() {
            if (this.uri != null) {
                URI uriCopy = this.uri;
                if (this.deleteOnClose) {
                    uriCopy = URIUtil.getTemporaryURI();
                    URIUtil.copyURIs(this.uri, uriCopy);
                }
                return new OverflowReadableDataLocation(uriCopy, this.deleteOnClose);
            }
            return new OverflowReadableDataLocation(this.bytes);
        }

        @Override
        public boolean isProtected() {
            return this.isProtected;
        }

        @Override
        public void setProtected(boolean protect) {
            this.isProtected = protect;
        }
    }
}

