/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.io.Writer;

public class ReaderInputStream
extends InputStream {
    private final Reader reader;
    private final Writer writer;
    private final PipedInputStream inPipe;

    public ReaderInputStream(Reader reader) throws IOException {
        this(reader, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReaderInputStream(Reader reader, String encoding) throws IOException {
        ReaderInputStream readerInputStream = this;
        synchronized (readerInputStream) {
            this.reader = reader;
            this.inPipe = new PipedInputStream();
            PipedOutputStream outPipe = new PipedOutputStream(this.inPipe);
            this.writer = encoding == null ? new OutputStreamWriter(outPipe) : new OutputStreamWriter((OutputStream)outPipe, encoding);
        }
        new Thread(new Copier()).start();
    }

    @Override
    public int read() throws IOException {
        return this.inPipe.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.inPipe.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.inPipe.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.inPipe.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.inPipe.available();
    }

    @Override
    public synchronized void close() throws IOException {
        ReaderInputStream.close(this.reader);
        ReaderInputStream.close(this.writer);
        ReaderInputStream.close(this.inPipe);
    }

    private static void close(Closeable cl) {
        try {
            cl.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private class Copier
    implements Runnable {
        private Copier() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            char[] buffer = new char[8192];
            try {
                while (true) {
                    ReaderInputStream readerInputStream = ReaderInputStream.this;
                    // MONITORENTER : readerInputStream
                    int n = ReaderInputStream.this.reader.read(buffer);
                    // MONITOREXIT : readerInputStream
                    if (n == -1) {
                        return;
                    }
                    readerInputStream = ReaderInputStream.this;
                    // MONITORENTER : readerInputStream
                    ReaderInputStream.this.writer.write(buffer, 0, n);
                    ReaderInputStream.this.writer.flush();
                    // MONITOREXIT : readerInputStream
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            finally {
                ReaderInputStream.close(ReaderInputStream.this.reader);
                ReaderInputStream.close(ReaderInputStream.this.writer);
            }
        }
    }
}

