/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.io;

import io.sdmx.api.format.FILE_FORMAT;
import io.sdmx.api.io.ReadableDataLocation;
import io.sdmx.utils.core.file.FormatUtil;
import io.sdmx.utils.core.io.StreamUtil;
import io.sdmx.utils.core.io.URIUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;

public class ReadableDataLocationTmp
implements ReadableDataLocation {
    private static final long serialVersionUID = 860775214722641122L;
    protected URI uri;
    protected boolean deleteOnClose = false;
    private String name;
    private boolean isClosed = false;
    private boolean isProtected = false;
    private Set<InputStream> inputStreams = new HashSet<InputStream>();
    private FILE_FORMAT format;

    public ReadableDataLocationTmp(String uriStr) {
        if (uriStr == null) {
            throw new IllegalArgumentException("Can not create StreamSourceData - uriStr can not be null");
        }
        try {
            this.uri = new URI(uriStr);
            if (this.uri.isAbsolute() && !this.uri.getScheme().equals("file")) {
                this.uri = URIUtil.getURIUtil().getUri(this.uri.toURL().openStream());
                this.deleteOnClose = true;
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ReadableDataLocationTmp(File f) {
        if (f == null) {
            throw new IllegalArgumentException("Can not create StreamSourceData - file can not be null");
        }
        this.uri = f.toURI();
        this.name = f.getName();
    }

    public ReadableDataLocationTmp(Path p) {
        this.uri = p.toUri();
        this.name = p.getFileName().toString();
    }

    public ReadableDataLocationTmp(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("Can not create StreamSourceData - url can not be null");
        }
        try {
            this.uri = URIUtil.getURIUtil().getUri(url.openStream());
            this.deleteOnClose = true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ReadableDataLocationTmp(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Can not create StreamSourceData - uri can not be null");
        }
        this.uri = uri;
    }

    public ReadableDataLocationTmp(InputStream is) {
        this.uri = URIUtil.getTemporaryURI();
        this.deleteOnClose = true;
        StreamUtil.copyStream(is, URIUtil.getOutputStream(this.uri));
        StreamUtil.closeStream(is);
    }

    @Override
    public InputStream getInputStream() {
        if (this.isClosed) {
            throw new RuntimeException("Can not obtain InputStream from ReadableDataLocation since it has been closed.");
        }
        InputStream is = URIUtil.getInputStream(this.uri);
        this.inputStreams.add(is);
        return is;
    }

    @Override
    public FILE_FORMAT getFormat() {
        if (this.format == null) {
            this.format = FormatUtil.determineFileFormat(this);
        }
        return this.format;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void close() {
        if (this.isClosed || this.isProtected) {
            return;
        }
        this.isClosed = true;
        if (this.deleteOnClose) {
            URIUtil.deleteUri(this.uri);
        } else {
            for (InputStream is : this.inputStreams) {
                StreamUtil.closeStream(is);
            }
        }
    }

    public String toString() {
        return this.uri.toString();
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public ReadableDataLocationTmp copy() {
        return new ReadableDataLocationTmp(this.getInputStream());
    }

    @Override
    public boolean isProtected() {
        return this.isProtected;
    }

    @Override
    public void setProtected(boolean protect) {
        this.isProtected = protect;
    }
}

