/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;

public class PropertiesHelper {
    public static Properties loadPropertiesFile(String fileName) throws FileNotFoundException, IOException {
        FileInputStream fis = new FileInputStream(fileName);
        Properties properties = new Properties();
        properties.load(fis);
        fis.close();
        return properties;
    }

    public static Properties loadPropertiesFileFromJar(String fileName) throws FileNotFoundException, IOException {
        InputStream in = PropertiesHelper.class.getClassLoader().getResourceAsStream(fileName);
        if (in == null) {
            throw new FileNotFoundException(fileName);
        }
        Properties properties = new Properties();
        properties.load(in);
        in.close();
        return properties;
    }

    public static void mergeProperties(String targetPropsFile, File sourceFile, String ... propsToCopy) throws FileNotFoundException, IOException {
        Properties source;
        try {
            source = PropertiesHelper.loadPropertiesFile(sourceFile.getAbsolutePath());
        }
        catch (Exception e) {
            System.out.println("Unable to load configuration file: " + sourceFile);
            System.out.println("Skipping application of this file");
            return;
        }
        Properties targetProps = PropertiesHelper.loadPropertiesFile(targetPropsFile);
        if (propsToCopy.length == 0) {
            Enumeration<?> e = source.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = (String)source.get(key);
                targetProps.setProperty(key, value);
            }
        } else {
            for (int i = 0; i < propsToCopy.length; ++i) {
                String key = propsToCopy[i];
                String value = (String)source.get(key);
                targetProps.setProperty(key, value);
            }
        }
        targetProps.store(new FileOutputStream(targetPropsFile), null);
    }

    public static Properties createLowerCaseProperties(Properties originalProperties) {
        Properties lowerCaseKeysProperties = new Properties();
        Set<Object> keySet = originalProperties.keySet();
        for (Object aKey : keySet) {
            lowerCaseKeysProperties.put(aKey.toString().toLowerCase(), originalProperties.get(aKey));
        }
        return lowerCaseKeysProperties;
    }
}

