/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.io;

import io.sdmx.api.exception.SdmxException;
import io.sdmx.api.format.FILE_FORMAT;
import io.sdmx.api.io.WriteableDataLocation;
import io.sdmx.utils.core.file.FormatUtil;
import io.sdmx.utils.core.io.StreamUtil;
import io.sdmx.utils.core.io.URIUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;

public class OverflowWriteableDataLocation
implements WriteableDataLocation {
    private static final long serialVersionUID = 2278635606454143014L;
    private static long maxMemory = 0x1E00000L;
    private static long currentMemory = 0L;
    private boolean isClosed = false;
    private boolean isProtected = false;
    private FILE_FORMAT format;
    private URI tmpUri;
    private OutputStream uriOut;
    private Buffer inMemoryBuffer = new Buffer();
    private String name;

    public OverflowWriteableDataLocation() {
        this((String)null);
    }

    public OverflowWriteableDataLocation(FILE_FORMAT fileFormat) {
        this((String)null);
        this.format = fileFormat;
    }

    public OverflowWriteableDataLocation(String name) {
        if (currentMemory > maxMemory) {
            this.tmpUri = URIUtil.getTemporaryURI();
            this.uriOut = URIUtil.getOutputStream(this.tmpUri);
        }
        this.name = name;
    }

    private OverflowWriteableDataLocation(String name, URI tmpUri) {
        this.name = name;
        this.tmpUri = tmpUri;
        this.uriOut = URIUtil.getOutputStream(tmpUri);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public FILE_FORMAT getFormat() {
        if (this.format == null) {
            this.format = FormatUtil.determineFileFormat(this);
        }
        return this.format;
    }

    @Override
    public InputStream getInputStream() {
        if (this.isClosed) {
            throw new RuntimeException("Can not obtain InputStream from OverflowWriteableDataLocation since it has been closed.");
        }
        if (this.uriOut == null) {
            if (this.inMemoryBuffer == null) {
                return null;
            }
            return new ByteArrayInputStream(this.inMemoryBuffer.toByteArray());
        }
        try {
            this.uriOut.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return URIUtil.getInputStream(this.tmpUri);
    }

    @Override
    public OutputStream getOutputStream() {
        return this.inMemoryBuffer;
    }

    @Override
    public void close() {
        if (this.isClosed || this.isProtected) {
            return;
        }
        this.isClosed = true;
        if (this.uriOut != null) {
            URIUtil.closeUri(this.tmpUri);
            URIUtil.deleteUri(this.tmpUri);
        } else if (this.inMemoryBuffer != null) {
            currentMemory -= (long)this.inMemoryBuffer.getCount();
            this.inMemoryBuffer = null;
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    public String toString() {
        if (this.tmpUri == null) {
            return new String(this.inMemoryBuffer.toByteArray());
        }
        return "OverflowWriteableDataLocation: " + this.tmpUri.toString();
    }

    public static void setMaxMemoryKb(long maxMemory) {
        OverflowWriteableDataLocation.maxMemory = maxMemory * 1024L;
    }

    public static long getCurrentMemory() {
        return currentMemory;
    }

    public static long getMaxMemory() {
        return maxMemory;
    }

    @Override
    public OverflowWriteableDataLocation copy() {
        if (this.tmpUri != null) {
            URI uriCopy = URIUtil.getTemporaryURI();
            try {
                this.uriOut.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            URIUtil.copyURIs(this.tmpUri, uriCopy);
            return new OverflowWriteableDataLocation(this.name, uriCopy);
        }
        OverflowWriteableDataLocation newOverflow = new OverflowWriteableDataLocation(this.name);
        StreamUtil.copyStream(this.getInputStream(), newOverflow.getOutputStream());
        return newOverflow;
    }

    @Override
    public boolean isProtected() {
        return this.isProtected;
    }

    @Override
    public void setProtected(boolean protect) {
        this.isProtected = protect;
    }

    private class Buffer
    extends ByteArrayOutputStream {
        private boolean isOverflow;

        private Buffer() {
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) {
            if (this.isOverflow) {
                try {
                    OverflowWriteableDataLocation.this.uriOut.write(b, off, len);
                }
                catch (IOException e) {
                    throw new SdmxException(e, "IO Exception whilst trying to write to file output stream: " + OverflowWriteableDataLocation.this.tmpUri);
                }
            } else {
                super.write(b, off, len);
                this.checkOverflow(len);
            }
        }

        public int getCount() {
            return this.count;
        }

        @Override
        public void write(int b) {
            if (this.isOverflow) {
                try {
                    OverflowWriteableDataLocation.this.uriOut.write(b);
                }
                catch (IOException e) {
                    throw new SdmxException(e, "IO Exception whilst trying to write to file output stream: " + OverflowWriteableDataLocation.this.tmpUri);
                }
            } else {
                super.write(b);
                this.checkOverflow(1);
            }
        }

        private void checkOverflow(int increment) {
            currentMemory += increment;
            if (currentMemory >= maxMemory) {
                this.isOverflow = true;
                if (OverflowWriteableDataLocation.this.tmpUri == null) {
                    OverflowWriteableDataLocation.this.tmpUri = URIUtil.getTemporaryURI();
                    OverflowWriteableDataLocation.this.uriOut = URIUtil.getOutputStream(OverflowWriteableDataLocation.this.tmpUri);
                }
                try {
                    this.writeTo(OverflowWriteableDataLocation.this.uriOut);
                }
                catch (IOException e) {
                    throw new SdmxException(e, "IO Exception whilst trying to overflow from in-memory outputstream to file output stream:" + OverflowWriteableDataLocation.this.tmpUri);
                }
                currentMemory -= this.count;
                this.buf = new byte[100];
                this.count = 0;
            }
        }

        @Override
        public void flush() throws IOException {
            if (OverflowWriteableDataLocation.this.uriOut != null) {
                OverflowWriteableDataLocation.this.uriOut.flush();
            }
        }
    }
}

