/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class MultipartOutputStream
extends FilterOutputStream {
    private static byte[] __CRLF;
    private static byte[] __DASHDASH;
    private static final String ISO88591 = "iso-8859-1";
    public static String MULTIPART_MIXED;
    public static String MULTIPART_X_MIXED_REPLACE;
    private byte[] boundaryBytes;
    private boolean inPart = false;

    public MultipartOutputStream(OutputStream out, String boundary) {
        super(out);
        try {
            this.boundaryBytes = boundary.getBytes(ISO88591);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.inPart) {
            this.out.write(__CRLF);
            this.out.write(__DASHDASH);
            this.out.write(this.boundaryBytes);
            this.out.write(__DASHDASH);
            this.out.write(__CRLF);
        }
        super.close();
    }

    public void startPart(String contentType, String formname, String fileName) throws IOException {
        if (this.inPart) {
            this.out.write(__CRLF);
        }
        this.inPart = true;
        this.out.write(__DASHDASH);
        this.out.write(this.boundaryBytes);
        this.out.write(__CRLF);
        this.out.write(("Content-Type: " + contentType).getBytes(ISO88591));
        this.out.write(__CRLF);
        this.out.write(("Content-Disposition: form-data; name= " + formname + "; filename=" + fileName).getBytes(ISO88591));
        this.out.write(__CRLF);
        this.out.write(__CRLF);
    }

    static {
        MULTIPART_MIXED = "multipart/mixed";
        MULTIPART_X_MIXED_REPLACE = "multipart/x-mixed-replace";
        try {
            __CRLF = "\r\n".getBytes(ISO88591);
            __DASHDASH = "--".getBytes(ISO88591);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

