/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.io;

import io.sdmx.api.format.FILE_FORMAT;
import io.sdmx.api.io.ReadableDataLocation;
import io.sdmx.api.io.WriteableDataLocation;
import io.sdmx.utils.core.file.FormatUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class InMemoryWriteableDataLocation
implements WriteableDataLocation {
    private static final long serialVersionUID = 1L;
    private boolean isProtected = false;
    private ByteArrayOutputStream out = new ByteArrayOutputStream();
    private GZIPOutputStream gzipstream;
    private FILE_FORMAT format;

    public InMemoryWriteableDataLocation(boolean gzip) {
        if (gzip) {
            try {
                this.gzipstream = new GZIPOutputStream(new BufferedOutputStream(this.out));
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    private InMemoryWriteableDataLocation(byte[] out, boolean gzip) {
        try {
            this.out.write(out);
            if (gzip) {
                this.gzipstream = new GZIPOutputStream(new BufferedOutputStream(this.out));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public byte[] toByteArray() {
        if (this.gzipstream != null) {
            try {
                this.gzipstream.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.out.toByteArray();
    }

    @Override
    public InputStream getInputStream() {
        BufferedInputStream is = new BufferedInputStream(new ByteArrayInputStream(this.toByteArray()));
        if (this.gzipstream != null) {
            try {
                return new GZIPInputStream(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return is;
    }

    @Override
    public FILE_FORMAT getFormat() {
        if (this.format == null) {
            this.format = FormatUtil.determineFileFormat(this);
        }
        return this.format;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void close() {
        if (this.isProtected) {
            return;
        }
        this.out = null;
    }

    @Override
    public boolean isClosed() {
        return this.out != null;
    }

    @Override
    public ReadableDataLocation copy() {
        return new InMemoryWriteableDataLocation(this.toByteArray(), this.gzipstream != null);
    }

    @Override
    public boolean isProtected() {
        return this.isProtected;
    }

    @Override
    public void setProtected(boolean protect) {
        this.isProtected = protect;
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.gzipstream != null) {
            return this.gzipstream;
        }
        return new BufferedOutputStream(this.out);
    }
}

