/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.io;

import io.sdmx.api.format.FILE_FORMAT;
import io.sdmx.api.io.ReadableDataLocation;
import io.sdmx.utils.core.file.FormatUtil;
import io.sdmx.utils.core.io.StreamUtil;
import io.sdmx.utils.core.io.URIUtil;
import io.sdmx.utils.core.io.URLUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class InMemoryReadableDataLocation
implements ReadableDataLocation {
    private static final long serialVersionUID = 971633373372917354L;
    private byte[] bytes;
    private String name;
    private boolean isClosed = false;
    private boolean isProtected = false;
    private FILE_FORMAT format = null;

    public InMemoryReadableDataLocation(InputStream stream) {
        this.bytes = StreamUtil.toByteArray(stream);
    }

    public InMemoryReadableDataLocation(byte[] bytes) {
        this(bytes, null);
    }

    public InMemoryReadableDataLocation(byte[] bytes, String name) {
        this.bytes = bytes;
        this.name = name;
    }

    public InMemoryReadableDataLocation(String uriStr) {
        if (uriStr == null) {
            throw new IllegalArgumentException("Can not create StreamSourceData - uriStr can not be null");
        }
        this.name = uriStr;
        try {
            URI uri = new URI(uriStr);
            if (uri.isAbsolute()) {
                if (!uri.getScheme().equals("file")) {
                    URL url = uri.toURL();
                    this.bytes = StreamUtil.toByteArray(URLUtil.getInputStream(url));
                } else {
                    this.bytes = URIUtil.getByteArray(uri);
                }
            } else {
                this.bytes = StreamUtil.toByteArray(URIUtil.getInputStream(uri));
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public FILE_FORMAT getFormat() {
        if (this.format == null) {
            this.format = FormatUtil.determineFileFormat(this);
        }
        return this.format;
    }

    @Override
    public InputStream getInputStream() {
        if (this.isClosed) {
            throw new RuntimeException("Can not obtain InputStream from InMemoryReadableDataLocation since it has been closed.");
        }
        if (this.bytes == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        return new ByteArrayInputStream(this.bytes);
    }

    @Override
    public void close() {
        if (this.isClosed || this.isProtected) {
            return;
        }
        this.isClosed = true;
        this.bytes = null;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public InMemoryReadableDataLocation copy() {
        return new InMemoryReadableDataLocation(this.bytes, this.name);
    }

    @Override
    public boolean isProtected() {
        return this.isProtected;
    }

    @Override
    public void setProtected(boolean protect) {
        this.isProtected = protect;
    }
}

