/*
 * Decompiled with CFR 0.152.
 */
package io.sdmx.utils.core.io;

import io.sdmx.api.format.FILE_FORMAT;
import io.sdmx.api.io.ReadableDataLocation;
import io.sdmx.utils.core.io.ReadableDataLocationTmp;
import io.sdmx.utils.core.io.StreamUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.GZIPInputStream;

public class GzipReadableDataLocation
implements ReadableDataLocation {
    private static final long serialVersionUID = 1L;
    private Set<InputStream> inputStreams = new HashSet<InputStream>();
    protected boolean isClosed = false;
    private boolean isProtected;
    protected ReadableDataLocation rdl;

    protected GzipReadableDataLocation() {
    }

    public GzipReadableDataLocation(ReadableDataLocation rdl) {
        this.rdl = rdl;
        this.isProtected = rdl.isProtected();
    }

    public GzipReadableDataLocation(File f) {
        this.rdl = new ReadableDataLocationTmp(f);
    }

    @Override
    public FILE_FORMAT getFormat() {
        return FILE_FORMAT.GZIP;
    }

    @Override
    public InputStream getInputStream() {
        if (this.isClosed) {
            throw new RuntimeException("Can not obtain InputStream from GzipReadableDataLocation since it has been closed.");
        }
        try {
            GZIPInputStream is = new GZIPInputStream(this.getRdl().getInputStream());
            this.inputStreams.add(is);
            return is;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getName() {
        return this.rdl.getName();
    }

    @Override
    public void close() {
        if (this.isClosed || this.isProtected) {
            return;
        }
        for (InputStream is : this.inputStreams) {
            StreamUtil.closeStream(is);
        }
        this.rdl.close();
        this.isClosed = true;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public ReadableDataLocation copy() {
        return new GzipReadableDataLocation(this.getRdl());
    }

    @Override
    public boolean isProtected() {
        return this.isProtected;
    }

    protected ReadableDataLocation getRdl() {
        return this.rdl;
    }

    @Override
    public void setProtected(boolean protect) {
        this.isProtected = protect;
        this.rdl.setProtected(protect);
    }
}

